#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <termios.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "sentences.h"

static int read_message(int fd, char *buf, int bufsiz)
{
  int n = 0;
  char c;
  memset(buf, 0, bufsiz);

  while(n < bufsiz && buf[n-1] != '\n') {
    if(read(fd, (char*)&c, 1) > 0) {
      buf[n++] = c;
    } else {
      /* error reading a byte or EOF */
      return 0;
    }
  }
  return 1;
}

int gps_find_sentence(gps_sentence foo, char *buffer, int fd)
{
  char head[8];
  char *search_string;
  char bigbuf[1024];

  memset(head, 0, sizeof(head));

  if(foo == GPGLL) {
    search_string = "GLL";
  }

  memset(bigbuf, 0, sizeof(bigbuf));

  while(read_message(fd, bigbuf, sizeof(bigbuf))) {
    strncpy(head, bigbuf, sizeof(head));
    if(strstr(head, search_string)) {
      strcpy(buffer,bigbuf);
      return 1;
    }
    memset(bigbuf, 0, sizeof(bigbuf));
  }
  
  return 0;
}

int gps_serial_open (const char *port)
{
  int err = 0;
  struct termios options;

  int fd = open(port,  O_RDWR | O_NOCTTY | O_NDELAY);

  if (fd < 1) {
    return -1;
  } else {
    fcntl(fd,F_SETFL,0);
    memset (&options, 0,sizeof(options));
    options.c_cflag |= CRTSCTS;            /* hadware flow on */
    options.c_cflag  &= ~PARENB;           /* no parity */
    options.c_cflag  &= ~CSTOPB;           /* one stopbit */
    options.c_cflag  &= CSIZE;
    options.c_cflag |= CS8;                /* 8N1 */
    options.c_cflag |= (CLOCAL | CREAD);   /* enable Localmode, receiver */
    options.c_cc[VMIN] = 0;                /* set min read characters if 0 */
    /*   VTIME takes over */
    options.c_cc[VTIME] = 40;          /* wait V_TIME ms for character */
    
    err = cfsetospeed(&options, B4800);
    if (err < 0) {
      printf ("Could not set output speed! Error = %d\n", err);
      close (fd);
      return -1;
    } 
    
    err = cfsetispeed(&options, B4800);
    if (err < 0) {
      printf ("Could not set input speed! Error = %d\n", err);
      close (fd);
      return -1;
    } 
    
    if (tcsetattr(fd,TCSANOW, &options) < 0) {
      printf ("Failed to set fd port options!\n");
      close (fd);
      return -1;
    } 
  } 
  
  return fd;
}
