#include "wavelan_support.h"
#include "network_db.h"

/* these aren't really wavelan-specific, but whatever */

void
get_scan_data(int sock, const char *ifname, scan_data_t *data)
{
  char *ap_mac = wavelan_get_access_point_mac(sock, ifname);
  char *essid  = wavelan_get_essid(sock, ifname);
	if (ap_mac == NULL || essid == NULL) return;
  strcpy(data->ap_mac, ap_mac);
  strcpy(data->essid, essid);

  data->bitrate       = wavelan_get_bit_rate(sock, ifname);
  data->frequency     = wavelan_get_frequency(sock, ifname);
  data->link_quality  = wavelan_get_link_quality();

  if(data->link_total == 0) {
    scan_data_t *old_data = network_db_lookup_data(ap_mac);

    if(old_data) {
       data->link_total = data->link_quality + old_data->link_total;
       data->link_samples = old_data->link_samples + 1;
       strcpy(data->location, old_data->location);
    }
    free(old_data);
  } else {
    data->link_samples++;
    data->link_total += data->link_quality;
  }

  free(ap_mac);
  free(essid);
}

