#ifndef __SCAN_DATA_H__
#define __SCAN_DATA_H__

#include "iwcommon.h"
#include "nmea/gpgll.h"

typedef struct scan_data_t {
  char essid[IW_ESSID_MAX_SIZE + 1];
  char ap_mac[18];

  long   bitrate;
  double frequency;

  int  link_quality;

  long link_total;
  int  link_samples;

  char location[1024];  
  
  gps_gpgll gps_coords; /* location of strongest signal */

  struct services { 
    int dhcp;
  } services;
} scan_data_t;

void get_scan_data(int sock, const char *ifname, scan_data_t *data);

#endif
