#include <stdio.h>
#include <assert.h>
#include <unistd.h>

#include "gps_db.h"
#include "scan_data.h"
#include "nmea/nmea.h"

int 
gps_current_gll(gps_gpgll *data)
{
  char buf[256];
  int fd = gps_serial_open("/dev/ttyS0");

  if(fd < 0) { 
    perror("opening serial port");
    return 0; 
  }

  memset(buf, 0, sizeof(buf));

  if(gps_find_sentence(GPGLL, buf, fd))
    parse_gpgll(buf, data);
  else {
    // fprintf(stderr, "Didn't find GPGLL record on device /dev/ttyS0\n");
    return 0;
  }

  close(fd);

  return 1;
}

int
gps_merge_interface_data(scan_data_t * scan, gps_gpgll *data)
{
  gps_record * strongest = NULL;

  if(scan == NULL || data == NULL)
    return 0;
  
  strongest = gps_db_lookup_strongest(scan->ap_mac);

  /* this won't work at the equator - oops! hope your GPS is plugged in, then! */
  if((strongest == NULL || scan->link_quality > strongest->key.link_quality) && data->longitude.degrees != 0) {
      memcpy(&(scan->gps_coords), data, sizeof(gps_gpgll));
  }

  return 1;
}











