/* new frontend for gtkskan */

#include "skan.h"
#include "gtkskan.h"
#include "network_db.h"
#include "skan_config.h"
#include <gtk/gtk.h>
#include <pthread.h>

GtkWidget *my_clist = NULL;
GtkWidget *location_entry = NULL;
GtkWidget *main_window = NULL;

static GtkWidget *my_statusbar = NULL;
static GtkWidget *total_statusbar = NULL;
static GtkWidget *scan = NULL, *stop = NULL;
static GtkItemFactory *if_menubar = NULL;   


gtkskan_config_t skan_conf;


gint delete_event(GtkWidget *widget,
		  GdkEvent *event,
		  gpointer data)
{
	g_print("delete event occurred\n");
	return (FALSE);
}

void destroy(GtkWidget *widget, gpointer data)
{
    gtk_main_quit();
}

/* User clicked the "Clear List" button. */
void button_clear_clicked( gpointer data )
{
    gtk_clist_clear( (GtkCList *) data);
    return;
}


void menu_delete(GtkWidget *widget, gpointer data) {
	scan_data_t tmp;
	gint row = (GTK_CLIST(my_clist))->focus_row;
	if (row != -1) {
		row_to_scan_data(GTK_CLIST(my_clist), row, &tmp);
		gtk_clist_remove(GTK_CLIST(my_clist), row);
		network_db_delete_data(&tmp);
		gtkskan_update_netcount();
	}
}

void display_popup(GtkWidget *widget, GdkEventButton *event, gpointer data) {
	if (event->button > 1) {
		gtk_item_factory_popup_with_data(GTK_ITEM_FACTORY(data), widget, NULL,
				(guint)event->x_root, (guint)event->y_root,
				event->button, event->time);
	}
}

void gtkskan_update_netcount(void) {
	gchar str[25];
	gint x = GTK_CLIST(my_clist)->rows;
	switch (x) {
		case 0: 
			snprintf(str, 24, "No networks found");
			break;
		case 1:
			snprintf(str, 24, "1 network found");
			break;
		default:
			snprintf(str, 24, "%d networks found", x);
	}
	gtk_statusbar_pop(GTK_STATUSBAR(total_statusbar), 1);
	gtk_statusbar_push(GTK_STATUSBAR(total_statusbar), 1, str);
}

void gtkskan_update_statusbar(gchar * str) {
	gtk_statusbar_pop(GTK_STATUSBAR(my_statusbar), 1);
	gtk_statusbar_push(GTK_STATUSBAR(my_statusbar), 1, str);
}

void open_about_dialog() { g_print ("This will open an about dialog.\n"); }

static GtkItemFactoryEntry menu_items[] = {
   { "/_File",         NULL,         NULL, 0, "<Branch>" },
// { "/File/Sca_n",     "<control>N", start_or_stop_scan, 0, NULL },
// { "/File/Sto_p",    "<control>P", start_or_stop_scan, 0, NULL }, 
// { "/File/_Save",    "<control>S", save_db, 0, NULL },
// { "/File/Save _As", "<control>A", new_db, 0, NULL }, 
// { "/File/sep1",     NULL,         NULL, 0, "<Separator>" },
   { "/File/_Quit",     "<control>Q", gtk_main_quit, 0, NULL },
   { "/_Options",      NULL,         NULL, 0, "<Branch>" },
   { "/Options/_Preferences",  "<control>P", gtkskan_prefs, 0, NULL },
   { "/_Help",         NULL,         NULL, 0, "<LastBranch>" },
   { "/_Help/About",   NULL,         open_about_dialog, 0, NULL },
};

void init_menubar(GtkWidget *window, GtkWidget **menubar)
{
  GtkAccelGroup *accel_group;
  gint nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);
  accel_group = gtk_accel_group_new ();
  if_menubar = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>",
                                      accel_group);
  gtk_item_factory_create_items (if_menubar, nmenu_items, menu_items, NULL);
  gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
    if (menubar)
            *menubar = gtk_item_factory_get_widget (if_menubar, "<main>");
}
                                                                           
void gtkskan_scanning(gboolean s) {
		gtk_widget_set_sensitive(stop, s);
		gtk_widget_set_sensitive(scan, !s);
}

void gtkskan_prefs(GtkWidget *widget, gpointer data) {
	gtkskan_configure(&skan_conf);
}

void gtkskan_data_sort(GtkCList *clist, gint column) {
	if (column > 5 || column < 0) 
		return;

	if (clist->sort_column == column) 
		clist->sort_type = (clist->sort_type == GTK_SORT_ASCENDING) ?
			GTK_SORT_DESCENDING : GTK_SORT_ASCENDING;

	gtk_clist_set_sort_column(clist, column);
	gtk_clist_sort(clist);
}

//int main (int argc, char *argv[])
void initialize_gui(void) {
    GtkWidget *window, *quit, *toolbar, 
		*iconw, *scrolled_window, *box1, *box2, *separator, 
		*location_label, *menubar;
    GdkPixmap *icon;
    GdkBitmap *mask;
    GtkStyle *style;
	GtkItemFactory *clist_menu;
	GtkItemFactoryEntry clist_menu_item =  { 
		"/_Delete", "<control>D", 
		menu_delete, 0, NULL 
	};	
	GString *tpath = g_string_new(NULL);
	
	gchar *titles[] = { "Network Name", "MAC Address           ", "Signal", "Avg. Signal", "Frequency  ", "Location", "Longitude", "Latitude" };
    
    // Create a window and give it the ability to close
    window = main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
    		       GTK_SIGNAL_FUNC(delete_event), NULL);
    gtk_signal_connect(GTK_OBJECT(window), "destroy",
    		       GTK_SIGNAL_FUNC(destroy), NULL);
    gtk_container_set_border_width(GTK_CONTAINER(window), 5); 
    gtk_window_set_title ( GTK_WINDOW ( window ) , "WaveLAN Skanner");
    gtk_widget_set_usize( GTK_WIDGET ( window ) , 700 , 350 );
    
    // Allow the windows to resize and realize for pixmaps
    GTK_WINDOW ( window ) ->allow_shrink = TRUE;
    gtk_widget_realize ( window );
    
    box1 = gtk_vbox_new (FALSE, 0);
    box2 = gtk_hbox_new (FALSE, 2);

	gtk_container_set_border_width(GTK_CONTAINER(box2), 1);
	gtk_container_set_border_width(GTK_CONTAINER(box1), 1);
    gtk_container_add(GTK_CONTAINER(window), box1);
    
    // First the menubar
    init_menubar (window, &menubar);
    gtk_box_pack_start (GTK_BOX (box1), menubar, FALSE, TRUE, 0);
    gtk_widget_show (menubar);
                       
    // K,: now for the toolbar
    toolbar = gtk_toolbar_new ( GTK_ORIENTATION_HORIZONTAL,
                                GTK_TOOLBAR_BOTH );
    gtk_container_set_border_width ( GTK_CONTAINER ( toolbar ) , 1 );
    gtk_toolbar_set_space_size ( GTK_TOOLBAR ( toolbar ), 0 );
         
    // And now for the go pixmap icon dealy
    style = gtk_widget_get_style( window );

	g_string_assign(tpath, "/go.xpm");
	g_string_prepend(tpath, DATA_DIR);
	icon = gdk_pixmap_create_from_xpm ( window->window, &mask,
			 &style->bg[GTK_STATE_NORMAL],
                         tpath->str );
        
    // Throw the go icon into the scan button and 
    // put the scan button into the toolbar
    iconw = gtk_pixmap_new( icon, mask ); 
	scan = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar), 
			"Scan", "Scan for wireless networks", "Private",
			iconw, GTK_SIGNAL_FUNC(start_or_stop_scan), NULL);
    gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );
                                                                                                                                                                                               
    // Add another icon button
	
	g_string_assign(tpath, "/stop.xpm");
	g_string_prepend(tpath, DATA_DIR);
    icon = gdk_pixmap_create_from_xpm ( window->window, &mask,
			 &style->bg[GTK_STATE_NORMAL],
                         tpath->str );
    iconw = gtk_pixmap_new( icon, mask );       

	stop = gtk_toolbar_append_item (GTK_TOOLBAR(toolbar), "Stop", 
			"Stop scan", "Private", iconw, 
			GTK_SIGNAL_FUNC(start_or_stop_scan), NULL);
	

    // Get our spacing on
    gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );
	
	location_label = gtk_label_new("Location: ");
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), location_label, NULL, NULL);
	gtk_widget_show(location_label);
    gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );
	location_entry = gtk_entry_new_with_max_length(1024);
	gtk_entry_set_text(GTK_ENTRY(location_entry), "No selection");
	gtk_toolbar_append_widget(GTK_TOOLBAR(toolbar), location_entry, NULL, NULL);
    gtk_signal_connect(GTK_OBJECT(location_entry), "activate",
    		       GTK_SIGNAL_FUNC(handle_save_location), 
				   NULL);
	gtk_widget_set_sensitive(location_entry, FALSE);
	gtk_widget_show(location_entry);
    gtk_toolbar_append_space( GTK_TOOLBAR(toolbar) );

/* Prefs button has been removed... 
	g_string_assign(tpath, "/prefs.xpm");
	g_string_prepend(tpath, DATA_DIR);

	icon = gdk_pixmap_create_from_xpm(window->window, &mask, 
			&style->bg[GTK_STATE_NORMAL], tpath->str);
	iconw = gtk_pixmap_new(icon, mask);
	
	prefs = gtk_toolbar_append_item (GTK_TOOLBAR(toolbar), "Prefs",
			"Preferences", "Private", iconw,
			GTK_SIGNAL_FUNC(gtkskan_prefs), NULL);
*/

	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));

	g_string_assign(tpath, "/exit.xpm");
	g_string_prepend(tpath, DATA_DIR);
	icon = gdk_pixmap_create_from_xpm(window->window, &mask,
			&style->bg[GTK_STATE_NORMAL], tpath->str);
	iconw = gtk_pixmap_new(icon, mask);

	quit = gtk_toolbar_append_item ( GTK_TOOLBAR (toolbar), 
			"Exit", "Exit gtkskan", "Private", iconw,
				GTK_SIGNAL_FUNC (destroy), NULL );

	
    gtk_toolbar_set_space_size (GTK_TOOLBAR(toolbar), 6);
    
    // Add the toolbar to the vbox (box1) and a seperator
    gtk_box_pack_start(GTK_BOX (box1), toolbar, FALSE, FALSE, 0);
    gtk_widget_show(toolbar);
    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, FALSE, 0);
    gtk_widget_show (separator);                 
    
    // Make sthe scrolled window
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_container_set_border_width (GTK_CONTAINER (scrolled_window), 5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    
    // Create the CList and put it in the scrolled_window
    my_clist = gtk_clist_new_with_titles( 8, titles);
	gtk_clist_column_titles_active(GTK_CLIST(my_clist));
    gtk_clist_set_shadow_type (GTK_CLIST(my_clist), GTK_SHADOW_OUT);
    gtk_clist_set_column_width (GTK_CLIST(my_clist), 0, 100);
    gtk_container_add(GTK_CONTAINER(scrolled_window), my_clist);
	gtk_signal_connect(GTK_OBJECT(my_clist), "select-row", 
			GTK_SIGNAL_FUNC(handle_clist_selection), NULL);
	gtk_signal_connect(GTK_OBJECT(my_clist), "click-column",
			GTK_SIGNAL_FUNC(gtkskan_data_sort), NULL);
	gtk_signal_connect(GTK_OBJECT(my_clist), "unselect-row",
			GTK_SIGNAL_FUNC(handle_clist_unselection), NULL);
	gtk_widget_show(my_clist);
    
	my_statusbar = gtk_statusbar_new();

	clist_menu = gtk_item_factory_new (GTK_TYPE_MENU, "<Menu>", NULL);
	gtk_item_factory_create_items(clist_menu, 1, &clist_menu_item, NULL);

	gtk_signal_connect(GTK_OBJECT(my_clist), "button-press-event", 
			GTK_SIGNAL_FUNC(display_popup),
			clist_menu);
	total_statusbar = gtk_statusbar_new();	
	// Box it all up 
    gtk_box_pack_start(GTK_BOX (box1), scrolled_window, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX (box2), my_statusbar, TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX (box2), total_statusbar, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX (box1), box2, FALSE, FALSE, 0);
	
	gtkskan_update_netcount();

	if (getuid() != 0) {
			g_warning("Scanning not available, you must be root to scan\n");
			gtk_widget_set_sensitive(scan, FALSE);
			gtk_widget_set_sensitive(stop, FALSE);
			gtkskan_update_statusbar("You must be root to scan.");
	} else
		gtkskan_scanning(FALSE);

	g_string_free(tpath, TRUE);

	gtk_widget_show(my_statusbar);
	gtk_widget_show(total_statusbar);
	gtk_widget_show (scrolled_window);
    gtk_widget_show (box1);
	gtk_widget_show (box2);
    gtk_widget_show(window);
}



int main(int argc, char **argv) {
	
	g_thread_init(NULL);
	
	gtk_init(&argc, &argv);
		
	gtkskan_load_config(&skan_conf);
	
	initialize_gui();
	initialize_interface_from_db();
	gtkskan_update_netcount();

	gdk_threads_enter();
	gtk_main();
	gdk_threads_leave();

	gtkskan_save_config(&skan_conf);
	return 0;
}
