/* gtkskan configuration gui and meaty bits */

#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include "skan_config.h"

extern gtkskan_config_t skan_conf;
extern GtkWidget *main_window;

void gtkskan_load_config(gtkskan_config_t *skan_config) {
	gboolean def;
	GString *foo = g_string_new(NULL);
	
	skan_config->interface =
		gnome_config_get_string_with_default("/gtkskan/config/interface=eth0", 
			&def);
	skan_config->sound =
		gnome_config_get_bool_with_default("/gtkskan/config/sound=TRUE", &def);
	
	g_string_assign(foo, "/gtkskan/config/snd_path=");
	g_string_append(foo, DATA_DIR);
	g_string_append(foo, "/netfound.wav");
	skan_config->snd_path = gnome_config_get_string_with_default(
			foo->str, &def);
	g_string_free(foo, TRUE);

}

void gtkskan_save_config(gtkskan_config_t *skan_config) {
	gnome_config_set_string("/gtkskan/config/interface", skan_config->interface);
	gnome_config_set_bool("/gtkskan/config/sound", skan_config->sound);
	gnome_config_set_string("/gtkskan/config/snd_path", skan_config->snd_path);
	gnome_config_sync();
}

GList * gtkskan_get_interface_list(void) {
	const gchar *fname = "/proc/net/dev";
	FILE *fp = NULL;
	gchar *foo, c;
	GList *ifaces = NULL;	
	if ((fp = fopen(fname, "r")) == NULL) return ifaces;

	CLEARBUF(fp,c);
	
	do {
		CLEARBUF(fp,c);
		foo = g_new(gchar,7);
		fgets(foo, 7, fp);
		if (feof(fp)) break;
		ifaces =  g_list_prepend(ifaces, g_strstrip(foo));
	} while (TRUE);

	fclose(fp);
	return ifaces;
}

void clear_glist(GList *list) {
	GList *tmp;
	for(tmp = list; tmp != NULL; tmp = tmp->next) 
		free((gchar*)tmp->data);
}

void config_handle_soundcheck(GtkWidget *widget, gpointer user_data) {
	gtkskan_config_t *skan_config = (gtkskan_config_t*)user_data;
	skan_config->sound = gtk_toggle_button_get_active(
			GTK_TOGGLE_BUTTON(widget));
	gtkskan_save_config(skan_config);	
}

void config_handle_combo_iface(GtkWidget *widget, gpointer user_data) {
	gtkskan_config_t *skan_config = (gtkskan_config_t*)user_data;
	gchar *interface = gtk_entry_get_text(GTK_ENTRY(widget));
	strcpy(skan_config->interface, interface);
	gtkskan_save_config(skan_config);
}

void config_handle_sndpath_ok(GtkWidget *widget, GtkFileSelection *fs) {
	g_free(skan_conf.snd_path);
	skan_conf.snd_path = 
		g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION (fs)));
	gtkskan_save_config(&skan_conf);
}

void config_handle_close(GtkWidget *widget, gpointer user_data) {
	gtk_widget_set_sensitive(main_window, TRUE);
	gtk_widget_destroy(user_data);
}

void gtkskan_configure(gtkskan_config_t *skan_config) {
	GtkWidget *window, *box1, *combo_ifaces, *sound_check, *if_label,
		*sndpath_select;
	GList *ifaces = NULL;
	
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", 
			GTK_SIGNAL_FUNC(config_handle_close), GTK_OBJECT(window));

	gtk_window_set_transient_for(GTK_WINDOW(window), GTK_WINDOW(main_window));
	gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

	
	gtk_container_set_border_width(GTK_CONTAINER(window), 5);
	gtk_window_set_title(GTK_WINDOW(window), "GTKSkan Config");
	gtk_widget_set_usize(GTK_WIDGET(window), 200, 120);
	GTK_WINDOW(window)->allow_shrink = TRUE;
	gtk_widget_realize(window);

	box1 = gtk_vbox_new(FALSE, 0);

	gtk_container_set_border_width(GTK_CONTAINER(box1), 1);
	gtk_container_add(GTK_CONTAINER(window), box1);
	
	if_label = gtk_label_new("Interface: ");
	gtk_container_add(GTK_CONTAINER(box1), if_label);
	
	combo_ifaces = gtk_combo_new();
	gtk_container_add(GTK_CONTAINER(box1), combo_ifaces);
	ifaces = gtkskan_get_interface_list();
	gtk_combo_set_popdown_strings(GTK_COMBO(combo_ifaces), ifaces);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo_ifaces)->entry), 
			skan_config->interface);
	clear_glist(ifaces);
	g_list_free(ifaces);
	gtk_combo_set_value_in_list(GTK_COMBO(combo_ifaces), TRUE, FALSE);


	sound_check = gtk_check_button_new_with_label("Sound on discovery");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sound_check), 
			skan_config->sound);
	gtk_container_add(GTK_CONTAINER(box1), sound_check);

	sndpath_select = gtk_file_selection_new("Network discovery sound path");
	
	gtk_signal_connect(GTK_OBJECT 
			(GTK_FILE_SELECTION(sndpath_select)->cancel_button), 
			"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			GTK_OBJECT(sndpath_select));
	
	gtk_signal_connect(GTK_OBJECT 
			(GTK_FILE_SELECTION(sndpath_select)->ok_button), 
			"clicked", GTK_SIGNAL_FUNC(config_handle_sndpath_ok),
			GTK_OBJECT(sndpath_select));

	gtk_signal_connect(GTK_OBJECT(sound_check), "clicked", 
			GTK_SIGNAL_FUNC(config_handle_soundcheck), skan_config);

	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo_ifaces)->entry), "activate",
			GTK_SIGNAL_FUNC(config_handle_combo_iface), skan_config);

	gtk_widget_show(if_label);	
	gtk_widget_show(combo_ifaces);
	gtk_widget_show(sound_check);
	gtk_widget_show(box1);
	gtk_widget_show(window);
	gtk_widget_set_sensitive(main_window, FALSE);
}
