#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "iwcommon.h"

int 
wavelan_set_essid(int sock, const char *ifname, const char *essid_in)
{
  char essid_buf[IW_ESSID_MAX_SIZE + 1];
  struct iwreq wrq;

  memset(&wrq, 0, sizeof(wrq));
  memset(essid_buf, 0, sizeof(essid_buf));

  strcpy(wrq.ifr_name, ifname);
  if(essid_in == NULL) {
    wrq.u.essid.flags = 0;
  } else {
    wrq.u.essid.flags = 1;
    strcpy(essid_buf, essid_in);
  }

  wrq.u.essid.pointer = (caddr_t) essid_buf;
  wrq.u.essid.length = strlen(essid_buf) + 1;

  if(ioctl(sock, SIOCSIWESSID, &wrq) < 0) {
    fprintf(stderr, "SIOCSIWESSID: %s (%s, %d)\n", strerror(errno), ifname, sock);
    return 0;
  }

  return 1;
}

char *
wavelan_get_essid(int sock, const char *ifname)
{
  struct iwreq		wrq;
  struct wireless_info  info_local, *info = &info_local;

  char   essid_buf[IW_ESSID_MAX_SIZE + 1];

  memset(essid_buf, 0, sizeof(essid_buf));
  memset(info, 0, sizeof(struct wireless_info));
  memset(&wrq, 0, sizeof(wrq));

  /* Get ESSID */
  strcpy(wrq.ifr_name, ifname);
  wrq.u.essid.pointer = (caddr_t) essid_buf;
  wrq.u.essid.length = 0;
  wrq.u.essid.flags = 0;
  if(ioctl(sock, SIOCGIWESSID, &wrq) >= 0) {
    info->has_essid = 1;
    info->essid_on = wrq.u.data.flags;
  } else {
    fprintf(stderr, "SIOCGIWESSID: %s\n", strerror(errno));    
  }

  if(info->has_essid == 0 || essid_buf[0] == '\0' || strcmp(essid_buf, "non-specified SSID !!") == 0)
    return NULL;

  return strdup(essid_buf);
}

char * wavelan_get_access_point_mac(int sock, const char *ifname)
{
  struct iwreq		wrq;
  struct wireless_info  info_local, *info = &info_local;

  memset(info, 0, sizeof(struct wireless_info));
  memset(&wrq, 0, sizeof(wrq));

  strcpy(wrq.ifr_name, ifname);

  if(ioctl(sock, SIOCGIWAP, &wrq) >= 0) {
    info->has_ap_addr = 1;
    memcpy(&(info->ap_addr), &(wrq.u.ap_addr), sizeof (sockaddr));
  }

  if(strcmp(info->ap_addr.sa_data, "DDDDDD") == 0) {
    return NULL;
  }
   
  return strdup(pr_ether(info->ap_addr.sa_data));
}

long  wavelan_get_bit_rate(int sock, const char *ifname)
{
  struct iwreq		wrq;
  struct wireless_info  info_local, *info = &info_local;

  memset(info, 0, sizeof(struct wireless_info));
  memset(&wrq, 0, sizeof(wrq));

  /* Get bit rate */
  strcpy(wrq.ifr_name, ifname);
  if(ioctl(sock, SIOCGIWRATE, &wrq) >= 0) {
    info->has_bitrate = 1;
    memcpy(&(info->bitrate), &(wrq.u.bitrate), sizeof(iwparam));
  }
  
  return info->bitrate.value;
}

double wavelan_get_frequency(int sock, const char *ifname)
{
  struct iwreq		wrq;
  struct wireless_info  info_local, *info = &info_local;

  memset(info, 0, sizeof(struct wireless_info));
  memset(&wrq, 0, sizeof(wrq));

  /* Get frequency / channel */
  strcpy(wrq.ifr_name, ifname);
  if(ioctl(sock, SIOCGIWFREQ, &wrq) >= 0) {
    info->has_freq = 1;
    info->freq = freq2float(&(wrq.u.freq));
  }

  return info->freq;
}

int    wavelan_get_link_quality(void)
{
  FILE *fp = fopen("/proc/net/wireless", "r");
  char buf[64], *p = buf + 15;

  fgets(buf, sizeof(buf), fp);
  fgets(buf, sizeof(buf), fp);
  fgets(buf, sizeof(buf), fp);

  *(p + 2) = '\0';

  return atoi(p);
}
