// Copyright (c) 2003 Michael Rosellini. All rights reserved.
// See COPYING for terms of license.

#import <FourCoordinates/FCDevice.h>
#import <FourCoordinates/FCObserved.h>


// Clean up the data from another device by removing lines with invalid
// checksums and data that doesn't fall between line delimiters and sending
// data a line at a time.  Forward all methods not implemented here
// directly to the cleaned device.
@interface FCCleanDevice : FCObserved <FCDevice> {
    id gpsDev;
    char *buffer;
    char *begin;
    char *end;
    char *limit;
}

+ (id)deviceWithDevice:(id)d;
- (id)initWithDevice:(id)d;

@end
