// Copyright (c) 2003 Michael Rosellini. All rights reserved.
// See COPYING for terms of license.

#import <Foundation/Foundation.h>
#include <time.h>


@class FCPoint;

typedef unsigned long FCChangeMask;
extern const FCChangeMask FCNoChange;
extern const FCChangeMask FCTimestampChanged;
extern const FCChangeMask FCLatitudeChanged;
extern const FCChangeMask FCLongitudeChanged;
extern const FCChangeMask FCQualityChanged;
extern const FCChangeMask FCNSatellitesChanged;
extern const FCChangeMask FCPdopChanged;
extern const FCChangeMask FCHdopChanged;
extern const FCChangeMask FCVdopChanged;
extern const FCChangeMask FCAltitudeChanged;
extern const FCChangeMask FCSpeedChanged;
extern const FCChangeMask FCHeadingChanged;
extern const FCChangeMask FCDeclinationChanged;
extern const FCChangeMask FCEverythingChanged;

// In order of worst to best...
typedef enum
{
    FCDeviceDisconnected=-1, FCNoFix=0, FCEstimated, FCGPS, FCDGPS
} FCQuality;
const char* FCQualityToString (FCQuality);

@interface FCData : NSObject <NSCopying> {
    struct tm timestamp;    // UTC (struct tm because NSDate & co are a pain)
    double latitude;        // Degrees; north is positive, south is negative
    double longitude;       // Degrees; west is negative, east is positive
    FCQuality quality;     // See enum FCQuality
    int nSatellites;        // Number of satellites used in calculation
    float pdop;             // Position Dilution of Precision % (3D)
    float hdop;             // Horizontal DOP % (2D--longitude/latitude)
    float vdop;             // Vertical DOP % (1D--altitude)
    float altitude;         // Meters
    float speed;            // Knots
    float heading;          // Degrees off of north, clockwise
    float declination;      // Degrees; west is negative, east is positive
    // Magnetic declination is the angle between true north and magnetic
    // north.  The horizontal coordinates reported by a FC are relative to
    // true north. I think.
}

+ (FCData*)data;

- (FCData*)initCopy:(FCData*)d;

- (struct tm)timestamp;
- (void)getTimestamp:(struct tm*)result;
- (FCPoint*)location;
- (double)latitude;
- (double)longitude;
- (FCQuality)quality;
- (int)nSatellites;
- (float)pdop;
- (float)hdop;
- (float)vdop;
- (float)altitude;
- (float)speed;
- (float)heading;
- (float)declination;

@end
