// Copyright (c) 2003 Michael Rosellini. All rights reserved.
// See COPYING for terms of license.

#import <FourCoordinates/FCDevice.h>
#import <FourCoordinates/FCObserved.h>


@interface FCDevDevice : FCObserved <FCDevice> {
    NSString *deviceFile;
    NSString *deviceName;
    int baud;
    int fd;
    char *ttyAttrs;
    char *buffer;
}

- (void)setBaud:(int)baud;
- (int)baud;
- (void)setName:(NSString*)name;
- (NSString*)name;

// I recommend that you stick to the factory functions in FCDevice.h.
- (id)initWithDeviceFile:(NSString*)deviceFile baud:(int)baud name:(NSString*)name;

@end
