// Copyright (c) 2003 Michael Rosellini. All rights reserved.
// See COPYING for terms of license.

#import <Foundation/Foundation.h>


@protocol FCDevice;

id<FCDevice> FCDeviceWithDeviceFileBaudName (
    NSString *deviceFile, int baud, NSString *name);
id<FCDevice> FCDeviceWithDeviceFileBaud (NSString *deviceFile, int baud);
id<FCDevice> FCDeviceWithDeviceFileName (NSString *deviceFile, NSString* name);
id<FCDevice> FCDeviceWithDeviceFile (NSString *deviceFile);
id<FCDevice> FCDeviceWithHostPort (NSString *host, int port);

extern const NSString *FCDeviceException;

@protocol FCDevice <NSObject>
- (void)open;
    // Open the device.  Throw FCDeviceException if this is not possible.
    // Take no action if already open.

- (void)close;
    // Close the device.  Take no action if already closed.

- (BOOL)read;
    // Read some data, send it to the observers.  Throw FCDeviceException
    // if this is not possible.  Return false if we reached EOF, true
    // otherwise.

// Does not retain/release.  Signature should be :(NSData*):(FCDevice*).
- (void)registerObserver:(id)observer withSelector:(SEL)selector;
- (void)unregisterObserver:(id)observer;
@end
