// Copyright (c) 2003 Michael Rosellini. All rights reserved.
// See COPYING for terms of license.

#import <FourCoordinates/FCDevice.h>
#import <FourCoordinates/FCMutableData.h>


extern NSString *const FCDataChangedNotification;
extern NSString *const FCDeviceDiedNotification;
extern NSString *const FCDataKey;
extern NSString *const FCChangeMaskKey;
extern NSString *const FCDeviceKey;

@interface FCMonitor : NSObject {
    id monitoring;
    FCMutableData *data;
    BOOL notifications;
    NSConditionLock *stopLock;
    NSConditionLock *runningLock;
    NSConditionLock *monitorLock;
    NSConditionLock *updatedLock;
    NSLock *dataLock;
    NSLock *notificationsLock;
}

+ (FCMonitor*)monitor;
    // Return a new monitor in the autorelease pool.

+ (NSArray*)enumerateDevices;
    // Return an array of all canidate GPS devices directly connected to
    // the computer (ie, serial devices).

- (FCData*)snapshot;
    // Return the current information.

// Notifications are off unless you request them.
// FCDataChangedNotification is sent whenever there is a change in the GPS
// data or status.  FCDeviceDiedNotification is sent when we receive EOF
// from the device.  An FCData* is keyed to FCDataKey for
// FCDataChangedNotification, and an NSNumber* is keyed to FCChangeMaskKey.
// An <id>FCDevice is keyed to FCDeviceKey for FCDeviceDiedNotification.
- (BOOL)notifications;
- (void)setNotifications:(BOOL)b;

- (void)monitor:(id)d;
    // Retain a device for monitoring.  Only one device will be monitored
    // at a time, for now.

- (void)unmonitor:(id)d;
    // Release a monitored device.  If d==nil, unmonitor all devices.

- (void)updateInNewThread;
    // Read from the monitored device(s) in a new thread until the monitor
    // is destroyed or stop is called.

- (void)stop;
    // Stop the update thread.

- (void)update;
    // Read enough data from our monitored device(s) to update our
    // coordinates.  This data may be in the device's input buffer or it
    // may entail a blocking read.  Beware.

@end
