// Copyright (c) 2003 Michael Rosellini. All rights reserved.
// See COPYING for terms of license.

#import <Foundation/Foundation.h>


@interface FCPoint : NSObject <NSCopying> {
    double latitude;
    double longitude;
    float altitude;
    float dop;
}

+ (FCPoint*)point;
+ (FCPoint*)pointWithPoint:(FCPoint*)p;
+ (FCPoint*)pointWithLongitude:(double)lng
                     latitude:(double)lat
                     altitude:(float)alt
                          dop:(float)dop;
+ (FCPoint*)pointWithLongitudeHemisphere:(char)longitudeHemisphere
                        longitudeDegrees:(int)longitudeDegrees
                        longitudeMinutes:(double)longitudeMinutes
                      latitudeHemisphere:(char)latitudeHemisphere
                         latitudeDegrees:(int)latitudeDegrees
                         latitudeMinutes:(double)latitudeMinutes
                                altitude:(float)a
                                     dop:(float)d;
+ (FCPoint*)pointWithString:(NSString*)str;
- (FCPoint*)initWithPoint:(FCPoint*)p;
- (FCPoint*)initWithLongitude:(double)lng
                     latitude:(double)lat
                     altitude:(float)alt
                          dop:(float)d;
- (FCPoint*)initWithLongitudeHemisphere:(char)longitudeHemisphere
                       longitudeDegrees:(int)longitudeDegrees
                       longitudeMinutes:(double)longitudeMinutes
                     latitudeHemisphere:(char)latitudeHemisphere
                        latitudeDegrees:(int)latitudeDegrees
                        latitudeMinutes:(double)latitudeMinutes
                               altitude:(float)a
                                    dop:(float)d;
- (FCPoint*)initWithString:(NSString*)str;
- (double)longitude;
- (char)longitudeHemisphere;
- (int)longitudeDegrees;
- (double)longitudeMinutes;
- (double)latitude;
- (char)latitudeHemisphere;
- (int)latitudeDegrees;
- (double)latitudeMinutes;
- (float)altitude;
- (double)dop;
- (NSString*)description;

@end
