#! /usr/bin/env python
##
#
# pyrawcovert - a python raw injection covert channel
# version 0.1
#
# Copyright (c) 2006, Laurent Butti
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
##
#
# This tool is a python-based proof-of-concept inspired from RawCovert
# tool released at ShmooCon2006. This version is the BlackHatUS'06 release!
# It is now fully functional and you may be able to initiate ping, scan,
# or ssh between two hosts thanks to this covert channel...
#
# It is available at: http://rfakeap.tuxfamily.org/
#
# Some parts are largery inspired from Cedric Blancher's
# wifitap code and of course Phil Biondi's scapy...
# so my greetings go to them!
#
##

# TODO
# - add a statistics summary (packets sent/received/dropped...)
# - add a crc32() check thanks to MAGIC_END packet
# - add an encryption engine

import socket,os,getopt,sys,time,struct,string

try:
    import psyco
    psyco.full()
except ImportError:
    print "Psyco not installed, may improve performance of your Python code..."
    pass

from socket import *
from fcntl import ioctl
from select import select

# Tweak here some magic numbers for the covert channel
MAGIC_START = "\x01\x02"
MAGIC_DATA  = "\x03\x04"
MAGIC_END   = "\x05\x06"

# Some default values
ACK_LEN     = 10
ETH_P_ALL   = 3

TUNSETIFF = 0x400454ca
TAPMODE   = 0x0002

DEBUG       = 0         # default to: no debug
ISPRISM     = 0         # default to: no prism header

IF_INJ      = "ath0"
IF_MON      = "ath0"
IF_TAP      = "tap0"

def usage(status=0):
    print "usage: pyrawcovert.py -m <if_mon> -i <if_inj> -t <if_tap> [-p] [-d] [-h]"
    print "     -m <if_mon> :   interface for monitoring device"
    print "     -i <if_inj> :   interface for injecting device"
    print "     -t <if_tap> :   interface for tap device"
    print "     -p          :   prism header enabled on monitoring device [not tested]"
    print "     -d          :   debug mode"
    print "     -h          :   help"
    sys.exit(status)

print "pyRawCovert (0.1) proof-of-concept code"
print "Copyright (c) 2006, Laurent Butti"
print ""

# Check options to be parsed 
opts = getopt.getopt(sys.argv[1:], "m:i:t:pdh")

for opt, optarg in opts[0]:
    if opt == "-m":
        IF_MON = optarg
    elif opt == "-i":
        IF_INJ = optarg
    elif opt == "-t":
        IF_TAP = optarg
    elif opt == "-p":
        ISPRISM = 1
    elif opt == "-d":
        DEBUG = 1
    elif opt == "-h":
        usage()

# Create a socket for monitoring thru wireless interface 
s_mon = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL))
s_mon.setsockopt(SOL_SOCKET, SO_RCVBUF, 0)
s_mon.bind((IF_MON,ETH_P_ALL))
s_mon.setsockopt(SOL_SOCKET, SO_RCVBUF, 2**30)

# Create a socket for injecting thru wireless interface
s_inj = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL))
s_inj.setsockopt(SOL_SOCKET, SO_SNDBUF, 0)
s_inj.bind((IF_INJ,ETH_P_ALL))
s_inj.setsockopt(SOL_SOCKET, SO_SNDBUF, 2**30)

print "Wireless Interface (monitoring)  :   %s" % IF_MON
print "Wireless Interface (injecting)   :   %s" % IF_INJ

# FIXME: Check if tun interface already exists
f = os.open("/dev/net/tun", os.O_RDWR)
ifs = ioctl(f, TUNSETIFF, struct.pack("16sH", "tap%d", TAPMODE))
ifname = ifs[:16].strip("\x00")

IF_TAP = ifname

print "Virtual Interface                :   %s" % IF_TAP

payload = ""

# Protocol Information #
# The covert channel is initiated thanks to a MAGIC_START packet
# Then the data is sent thanks to MAGIC_DATA packets
# Till the end of the communucation thanks to a MAGIC_END packet

# MAGIC_START packet is composed of:
# Frame Control:    0xD4    (compliant with 802.11 standard)
# Capabilities:     0x00    (compliant with 802.11 standard)
# Duration Field:   0x0000  (arbitrary choosen)
# Receiver Address: (6 bytes)
#   2 bytes for MAGIC_START value
#   2 bytes for total payload length
#   2 bytes defaulted to zero (padding)

# MAGIC_DATA packet is composed of:
# Frame Control:    0xD4    (compliant with 802.11 standard)
# Capabilities:     0x00    (compliant with 802.11 standard)
# Duration Field:   0x0000  (arbitrary choosen)
# Receiver Address: (6 bytes)
#   2 bytes for MAGIC_DATA value
#   4 bytes for payload (padded to zero if last fragment is less than 4 bytes)

# MAGIC_END packet is composed of:
# Frame Control:    0xD4    (compliant with 802.11 standard)
# Capabilities:     0x00    (compliant with 802.11 standard)
# Duration Field:   0x0000  (arbitrary choosen)
# Receiver Address: (6 bytes)
#   2 bytes for MAGIC_END value
#   4 bytes for crc32() (not implemented, padded to zero)

try:
    while 1:
        # Use select() for asynchronous I/O
        r = select([f,s_mon],[],[])[0][0]
        # Got a packet on wireless interface
        if r == s_mon:
            ack_recv = s_mon.recv(ACK_LEN + ISPRISM * 144)
            # Grep it!
            if ack_recv[ISPRISM*144] == "\xD4":
                if ack_recv[4+ISPRISM*144:6+ISPRISM*144] == MAGIC_START:
                    if DEBUG: print "DEBUG: %s: ACK received: MAGIC_START" % IF_MON 
                    length = ack_recv[6+ISPRISM*144:8+ISPRISM*144] 
                    length = ord(length[0])*256+ord(length[1])
                    #continue
                if ack_recv[4+ISPRISM*144:6+ISPRISM*144] == MAGIC_DATA:
                    if DEBUG: print "DEBUG: %s: ACK received: MAGIC_DATA" % IF_MON
                    payload += ack_recv[6:]
                    #continue
                if ack_recv[4+ISPRISM*144:6+ISPRISM*144] == MAGIC_END:
                    if DEBUG: print "DEBUG: %s: ACK received: MAGIC_END" % IF_MON
                    # FIXME: Check for Ethernet Size Header if below, drop the packet
                    # FIXME: Check for crc32() sanity
                    buf = "\x00\x00" + payload[12+ISPRISM*144:14+ISPRISM*144] + payload[ISPRISM*144:length+ISPRISM*144]
                    os.write(f,buf)
                    if DEBUG: print "DEBUG: %s: Reinjected frame in tap interface" % IF_TAP
                    payload = ""
        else:
            buf = os.read(f,1526)
            if len(buf) < 4:
                if DEBUG: "DEBUG: %s: Packet to short" % IF_TAP
                #continue
            a = chr(len(buf[4:])/256)
            b = chr(len(buf[4:])%256)
            ack = "\xD4\x00\x00\x00" + MAGIC_START + a + b + "\x00\x00"
            s_inj.send(ack)
            if DEBUG: print "DEBUG: %s: ACK sent: MAGIC_START" % IF_INJ
            for i in range(0,len(buf[4:])/4 + 1):
                ack = "\xD4\x00\x00\x00" + MAGIC_DATA + buf[4*(i+1):4*(i+2)]
                if len(ack) < 10:
                    if DEBUG: print "DEBUG: %s: Padding ACK with zeroes" % IF_INJ
                    for j in range(len(ack), 10):
                        ack += "\x00"
                s_inj.send(ack)
                if DEBUG: print "DEBUG: %s: ACK sent: MAGIC_DATA" % IF_INJ
                # FIXME: Add a crc32 on MAGIC_END packet
            ack = "\xD4\x00\x00\x00" + MAGIC_END + "\x00\x00\x00\x00"
            s_inj.send(ack)
            if DEBUG: print "DEBUG: %s: ACK sent: MAGIC_END" % IF_INJ

except KeyboardInterrupt:
    print "Stopped by the user..."

s_mon.close()
s_inj.close()
os.close(f)

sys.exit()
