/*
 * arp-god :>
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <pcap.h>
#include <libnet.h>
#include <thcrut/common.h>
#include <thcrut/arpg.h>

#define PCAPBUFSIZE		1024

extern struct _lnet lnet;
extern struct _opt opt;
struct _pcap pcap;

void
do_atexit()
{
	pcap_close(pcap.ip_socket);
}

void
arpd_signal(int s)
{
	switch (s)
	{
		case SIGINT:
		case SIGQUIT:
		case SIGTERM:
			exit(0);
	}

}

/*
 * send out ARP-REPLY from ip/mac to ip/mac
 * return 0 ono success...
 */
int
send_arp(u_short proto, u_long spf_sip, u_char spf_smac[6],
	u_long spf_dip, u_char spf_dmac[6])
{
	int c;

	libnet_build_ethernet (spf_dmac,
		spf_smac,
		ETHERTYPE_ARP,
		NULL,
		0,
		lnet.packet);

	libnet_build_arp (ARPHRD_ETHER,
		ETHERTYPE_IP,
		6,
		4,
		proto,
		spf_smac,
		(u_char *)&spf_sip,
		spf_dmac,
		(u_char *)&spf_dip,
		NULL,
		0,
		lnet.packet + LIBNET_ETH_H);

	lnet.packet_size = LIBNET_ETH_H + LIBNET_ARP_H;
	c = libnet_write_link_layer (opt.network,
		opt.device,
		lnet. packet,
		lnet.packet_size);
	if (c < lnet.packet_size)
		libnet_error(LIBNET_ERR_WARNING,
			"libnet_write_link_layer, only %d bytes\n", c);

	return 0;
}

/*
 * called by libpcap 
 */
static void
filter_packet (u_char *u, struct pcap_pkthdr *p, u_char *packet)
{
	static u_char *align_buf = NULL;
	struct Ether_header *eth;

	if (p->caplen < (opt.dlt_len + ETH_ARP_H))
		return;

	eth = (struct Ether_header *) (packet);

	if (align_buf == NULL)
		align_buf = (u_char *) malloc(PCAPBUFSIZE);

	memcpy(align_buf, packet + opt.dlt_len, p->caplen - opt.dlt_len);
	
	switch (ntohs (eth->ether_type))
	{
		case ETHERTYPE_ARP:
			opt.handle_arp(align_buf, p->caplen - opt.dlt_len);
			break;
		case ETHERTYPE_IP:
			opt.handle_ip(align_buf, p->caplen - opt.dlt_len);
			break;
	}

}

/*
 * init sniffer (we need this to read arp-requests to our spoofed address
 */
void
init_pcap()
{
	struct bpf_program prog;
	bpf_u_int32 network, netmask;

	if (pcap_lookupnet (opt.device, &network, &netmask, pcap.err_buf) < 0)
		die(-1, "pcap_loopupnet failed: %s", pcap.err_buf);

	pcap.ip_socket = pcap_open_live (opt.device,
		PCAPBUFSIZE,
		0,
		PCAPBUFSIZE,
		pcap.err_buf);

	if (pcap_datalink (pcap.ip_socket) != DLT_EN10MB)
		die(-1, "unsupported media, arpd exiting: %s");

	if (pcap_compile (pcap.ip_socket, &prog, PCAP_FILTER, 1, netmask) < 0)
		die(-1, "pcap_compile failed: %s", pcap.err_buf);

	if (pcap_setfilter (pcap.ip_socket, &prog) < 0)
		die(-1, "pcap_set_filter failed: %s", pcap.err_buf);

}

void
start_arpd()
{

	//arpip = addr;
	//memcpy(arpmac, mac, ETH_ALEN);

    if ((opt.arpdpid = fork()) == 0)
    {
		atexit(do_atexit);
		signal(SIGINT, arpd_signal);
		signal(SIGQUIT, arpd_signal);
		signal(SIGTERM, arpd_signal);
        init_pcap();
		while (1)
			pcap_loop (pcap.ip_socket, -1, (pcap_handler) filter_packet, NULL);

        exit(0);
    }
	signal(SIGCHLD, SIG_IGN);	/* parent must w8 to free kernel struct */
    if (opt.arpdpid == -1)
        die(-1, "unable to fork arp-daemon");
}

