#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef HAVE_CONFIG_H
# if STDC_HEADERS
#  include <string.h>
# else
#  ifndef HAVE_STRCHR
#   define strchr index
#   define strrchr rindex
#  endif
char *strchr (), *strrchr ();
#  ifndef HAVE_MEMCPY
#   define memcpy(d, s, n) bcopy ((s), (d), (n))
#   define memmove(d, s, n) bcopy ((s), (d), (n))
#  endif
# endif
#else
# include <string.h>
#endif            
#include <thcrut/range.h>


/*
 * input: "mac_start[-mac_end][trash may follow..like :ip-ip]"
 * return filled bmac struct for next_mac calls
 * FIXME: this does only work on ethernet (sscanf uses fixed size)
 * -1 = error: start > end
 */
int
init_next_mac(unsigned char *addr, struct _bmac *bmac)
{
    unsigned short m[ETH_ALEN];  /* start mac range */
    unsigned short e[ETH_ALEN];  /* end mac range */
    unsigned char  *ptr;
    int c,c2;
    unsigned long count=0;    /* this variable can overflow */
    unsigned long ocount=0;     /* to detect wrap arounds */

    memset(m, 0, sizeof(m));
    memset(e, 0, sizeof(e));

	sscanf(addr, "%hx:%hx:%hx:%hx:%hx:%hx-%hx:%hx:%hx:%hx:%hx:%hx",
             &m[0], &m[1], &m[2], &m[3], &m[4], &m[5],
             &e[0], &e[1], &e[2], &e[3], &e[4], &e[5]);

    if (strchr(addr, '-') == NULL)
        memcpy(e, m, ETH_ALEN * sizeof(short int));     /* only one mac given */

    /* this just if someone passed a 'no no good' addr-string
     * to this funktion. broken: mac1-mac2:ipA-ipB\0 
     * 'good' addr-strings are: mac1-mac2\0
     */
    if ( (ptr = strchr(addr, '-')) != NULL) /* second mac, maybe..?*/
        if ( strchr(++ptr, ':') == NULL)    /* NO!. then just one mac! */
            memcpy(e, m, ETH_ALEN * sizeof(short int));

    for (c = 0; c < ETH_ALEN; c++)
        if (m[c] < e[c])
            break;

    /*
     * c has the position where the least significant octets start to differ
     * 0 means its each octed of the macrange differs.
     * 6 means they do NOT differ (same mac).
     * 5 means all but the last least significant octet differs.
     */

    /* if we submitted ONE mac, range of size 1 */
    if ( (c == ETH_ALEN) && (memcmp(m, e, ETH_ALEN * sizeof(short int)) != 0) )
        return -1;

    /*
     * calculate how many different macs we have.
     * we are very lazy. -1 just means TO MANY...
     */
    count = 1;
    for (c2 = ETH_ALEN-1; c2 >= c; c2--)
    {
        count += ((e[c2] - m[c2]) * 1<<((ETH_ALEN-c2-1)*8));
        if (count < ocount)
        {
            count = -1;
            break;
        }
        ocount = count;
    }

    bmac->count = count;
    bmac->ltag = c;     /* save position where mac starts to differ */
    bmac->saved_ltag = c;
    bmac->firstround = 1;

	for (c = 0; c < ETH_ALEN; c++)
    {
		bmac->start_mac[c] = (unsigned char) m[c];
        bmac->end_mac[c] = (unsigned char) e[c];
    }
    memcpy(bmac->saved_sm, bmac->start_mac, ETH_ALEN);
    memcpy(bmac->saved_em, bmac->end_mac, ETH_ALEN);
    memcpy(bmac->current, bmac->start_mac, ETH_ALEN);

    return 0;

}

/*
 * reset bmac to initial value
 */
int
reset_next_mac(struct _bmac *bmac)
{
    memcpy(bmac->start_mac, bmac->saved_sm, ETH_ALEN);
    memcpy(bmac->end_mac, bmac->saved_em, ETH_ALEN);
    memcpy(bmac->current, bmac->saved_sm, ETH_ALEN);
    bmac->ltag = bmac->saved_ltag;
    bmac->firstround = 1;
    
    return 0;
}

/*
 * return next mac in set
 * no guarantee that mac's are returned sequential...
 * return NULL if no mac left in set.
 */
unsigned char *
next_mac(struct _bmac *bmac)
{
    int c;

    if (bmac->firstround != 0)
    {
        bmac->firstround = 0;
        return bmac->current;
    }

    if (bmac->ltag > ETH_ALEN-1)
        return NULL;

    for (c = ETH_ALEN-1; c >= bmac->ltag; c--)
    {
        if (c <= bmac->ltag)    /* == */
        {
            bmac->current[c] += 1;
            if (bmac->current[c] == bmac->end_mac[c])
                bmac->ltag++;
            break;
        }
        if (bmac->current[c] < 0xff)
        {
            bmac->current[c] += 1;
            break;
        }
        bmac->current[c] = 0;
    }


    return bmac->current;
}

/*
 * init bip-field
 * we eat 'w.x.y.z' and 'a.b.c.d-w.x.y.z' and also nummeric 
 * ip representation like 2130706433 for 127.0.0.1
 * (numbers-and-dots notation)
 * return 0 on success
 * bip saves everything in HBO
 */
int
init_next_ip(char *addr, struct _bip *bip)
{
    char *ptr;
    unsigned long sip, eip;

    if ( (ptr = strchr(addr, '-')) != NULL)
    {
        *ptr++ = '\0';
        eip = inet_addr(ptr);
    } else {
        eip = inet_addr(addr);
    }
    sip = inet_addr(addr);

    bip->start_ip = ntohl(sip);

    bip->end_ip = ntohl(eip);
    bip->current = bip->start_ip;

    return 0;
}

/*
 * return -1 if done
 * unsigned long in HBO
 * if target is not NULL the function is reentrant
 */
unsigned long *
next_ip(struct _bip *bip, unsigned long *target)
{
    static unsigned long thisip;
    unsigned long *lptr;

    if (target == NULL)
        lptr = &thisip;
    else
        lptr = target;

    if ((bip->current < bip->start_ip) || (bip->current > bip->end_ip))
        return NULL;

    *target = bip->current++;   /* user could change bip..*/

    return target;
}

