#
#   wicrawl - A modular and thorough wi-fi scanner
#   http://midnightresearch.com/projects/wicrawl - for details
#
#   Original Code:  Aaron Peterson
#   Contributors:
#   $Id: AccessPoint.pm,v 1.6 2006/04/23 21:03:16 cybernmd Exp $
#
#   Copyright (C) 2005-2006 Midnight Research Laboratories
#
#   THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTY IS ASSUMED.
#   NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
#   FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED. IT CAN BURN
#   YOUR HARD DISK, ERASE ALL YOUR DATA AND BREAK DOWN YOUR
#   MICROWAVE OVEN. YOU ARE ADVISED.
#
#   wicrawl is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.  For details see doc/LICENSE.

package AccessPoint;
use strict;

my $VERSION=0.1;

sub new {
	my $class = shift;
	my $self  = {
		SSID       => undef,
		BSSID      => undef,
		TIME       => undef,
		PACKETS    => undef,
		PLUGIN     => undef,
		PLUGINPATH => [],
		EVENT      => undef,
		TIMESTAMP  => undef,
		ENCRYPTION => undef,
		POWER      => undef,
		CHANNEL	   => undef,
		LONGITUDE => undef,
		LATITUDE => undef
	};
	bless ($self, $class);
	return $self;
}

sub ssid {
	my $self = shift;
	if (@_) { $self->{SSID} = shift }
	return $self->{SSID};
}

sub bssid {
	my $self = shift;
	if (@_) { $self->{BSSID} = shift }
	return $self->{BSSID};
}

# This is a timestamp in seconds
sub time {
	my $self = shift;
	if (@_) { $self->{TIME} = shift }
	return $self->{TIME};
}

sub packets {
	my $self = shift;
	if (@_) { $self->{PACKETS} = shift }
	return $self->{PACKETS};
}

sub plugin {
	my $self = shift;
	if (@_) { $self->{PLUGIN} = shift }
	return $self->{PLUGIN};
}

sub setpluginpath {
	my $self = shift;
	my $lvl = shift;
	my $name = shift;
	$self->{PLUGINPATH}[$lvl] = $name;
	return 0;
}

sub getpluginpath {
	my $self = shift;
	my $lvl = shift;
	my $name=$self->{PLUGINPATH}[$lvl];
	return $name;
}

sub timestamp {
	my $self = shift;
	if (@_) { $self->{TIMESTAMP} = shift }
	return $self->{TIMESTAMP};
}

sub event {
	my $self = shift;
	if (@_) { $self->{EVENT} = shift }
	return $self->{EVENT};
}

# text: WEP, WPA, NONE
sub encryption {
	my $self = shift;
	if (@_) { $self->{ENCRYPTION} = shift }
	return $self->{ENCRYPTION};
}

# In what?
sub power {
	my $self = shift;
	if (@_) { $self->{POWER} = shift }
	return $self->{POWER};
}

sub channel {
	my $self = shift;
	if (@_) { $self->{CHANNEL} = shift }
	return $self->{CHANNEL};
}

sub latitude {
	my $self = shift;
	if (@_) { $self->{LATITUDE} = shift }
	return $self->{LATITUDE};
}

sub longitude {
	my $self = shift;
	if (@_) { $self->{LONGITUDE} = shift }
	return $self->{LONGITUDE};
}

1;
