/*
 * @file wicrawl.h
 *
 * This is the main header for the wicrawl sources.  All other headers
 * should be included via this file.
 *
 * wicrawl - A modular and thorough wi-fi scanner
 * http://midnightresearch.com/projects/wicrawl - for details
 *
 * Original Code: jspence, focus
 * Contributors:
 * $Id: wicrawl.h,v 1.10 2006/09/17 22:41:14 jspence Exp $
 *
 * Copyright (C) 2005-2006 Midnight Research Laboratories
 *
 * THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTY IS ASSUMED.
 * NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED. IT CAN BURN
 * YOUR HARD DISK, ERASE ALL YOUR DATA AND BREAK DOWN YOUR
 * MICROWAVE OVEN. YOU ARE ADVISED.
 *
 * wicrawl is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.  For details see doc/LICENSE.
 */

/*
 * Standard C library headers.
 */
#include <ctype.h>
#include <math.h>
#include <stdarg.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/*
 * POSIX headers.
 */
#include <errno.h>
#include <fcntl.h>
#include <netdb.h>
#include <unistd.h>
#include <signal.h>
#include <pthread.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/file.h>

/*
 * Platform-specific socket headers.  We just need enough to call
 * socket(3) at this point.  This is nice because the set of target
 * platforms is the same as the set of platforms which provide these
 * three headers:
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

/*
 * Headers for other packages we use.
 */
#include <getopt.h>
#include <pcap.h>

/*
 * Platform-specific wireless headers.
 */
// FreeBSD wireless API
#ifdef FreeBSD
#include <net80211/ieee80211_ioctl.h>
#endif

// Linux wireless API
#ifdef linux
#include <linux/wireless.h>
typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;
#include "ieee80211_radiotap.h"

#endif

// Windows
#ifdef _WIN32
#include <wpcap.h>
#endif

/*
 * Headers for our sources.
 */
#include "80211.h"
#include "discovery.h"
#include "errlib.h"
#include "hash.h"
#include "util.h"
#include "version.h"
