#!/bin/bash
#
# This is a plugin that will bruteforce wpa pre-shared keys based on a
# dictionary attack.  It uses cowpatty, and requires that john the ripper is
# already installed.
#
# http://midnightresearch.com/projects/wicrawl
#
# Plugin Written by: Aaron Peterson 
# CoWPAtty Written by: Josh Wright
# 
# CoWPAtty available here: http://www.churchofwifi.org/default.asp?PageLink=Project_Display.asp?PID=95
# Thanks to Josh Wright for doing all the hard work, :)
#
# TODO: If pcap doesn't contain a handshake, then tcpdump until we get one...

while getopts "b:e:i:n:r:s:v:" options; do
  case $options in
    b ) bssid=$OPTARG;;
    e ) encryption=$OPTARG;;
    i ) interface=$OPTARG;;
    n ) nick=$OPTARG;;
    r ) run=$OPTARG;;
    s ) ssid=$OPTARG;;
    v ) version=$OPTARG;;
    * ) echo "Not sure what $OPTARG is, ignoring for now";;
  esac
done

if [ "$ssid" == "" ] ; then
	echo "  [!] Error: Need to pass in -s SSID"
	exit 1
fi

john=$(which john 2>/dev/null)
if [ "$john" == "" ] ; then
    echo " [!!] Can't find john (from john the ripper) in the path"
		echo "      please install it and try again.."
    exit 1
fi
john="$john -incremental -stdout"

echo "  [*] CoWPAtty WPA-PSK Dictionary Brute force plugin";

basedir=$( dirname $0 )
cowpatty="$basedir/cowpatty/cowpatty"

if [ ! -x "$cowpatty" ] ; then
	echo "  [!] CoWPAtty binary [$cowpatty] wasn't found, did you compile wicrawl?"
	exit 1
fi

pcapfile=$WICRAWL_PCAPFILE

# We get the pcap file from the environment (plugin-engine), need to
# make sure it's set and exists
pcapfile=$WICRAWL_PCAPFILE
if [ -z "$pcapfile" ] ; then
	echo "  [!] It doesn't appear that the pcapfile is set"
	echo "      Are you running this from the plugin-engine? or have"
	echo "      an old version? (we're expecting WICRAWL_PCAPFILE set in the env)"
	exit 1
fi

if [ ! -f "$pcapfile" ] ; then
	echo "  [!] pcap file [$pcapfile] does not appear to exist"
	exit 1
fi

cowpatty="$cowpatty -f - -s \"$ssid\" -r $pcapfile"

echo "  [*] Running [$john | $cowpatty]"

# The PSK is "dictionary".
# incomplete TKIP four-way exchange
output=$( $john | $cowpatty | egrep "The PSK is|incomplete TKIP four-way" )

if [[ "$output" =~ "The PSK is" ]] ; then
	echo "  [*] Good News! CoWPAtty says [$output]"
	exit 8
elif [[ "$output" =~ "incomplete TKIP four-way exchange" ]] ; then

	# TODO Need to run tcpdump here to get it rather than failing...
	echo "  [!] Failed. PCAP file does not contain a TKIP four-way exchange"
	exit 1
fi

# TODO
# Need to actually try to associate with this key now that we found it.

exit 0

# vim:ts=2:sw=2:sts=0
