#!/usr/bin/perl -w
#
# nmap plugin script for wicrawl
# http://midnightresearch.com/projects/wicrawl

use strict;
use Getopt::Std;
use XML::Smart;
$Getopt::Std::STANDARD_HELP_VERSION='1';

my $bssid=0; my $encryption=0; my $ssid=0; my $interface=0; my $nick=0; my $version=0;
our($opt_b, $opt_e, $opt_i, $opt_s, $opt_n, $opt_v);
my $rc;
my $nmap;

my $ip;
my $counter=0;
my $time = time;
# TODO need to replace this with secure file creation (File::Temp or similar)
my $output = "/tmp/nmap-output-$time.xml";


#####################################################################
# functions
sub get_ip() {
	my $ip = `ifconfig $interface | grep "inet addr"`;
	$ip =~ /(inet addr:)(\d+\.\d+\.\d+\.\d+)/;
	if($2) {print "Your IP is: $2\n";}
	return $2;

}

sub nmap_exec() {

	print "Scanning Local Network...\n";

	my @args = ("-e $interface","-PE","$ip\/24","-oX $output");
	`$nmap @args`;

	my $XML = XML::Smart->new($output);

	my $size=(stat("$output"))[7];

	# We only want to search through the xml file if it exists
	# Otherwise it will create an empty entry
	if ((defined($size)) && ($size >= 122)) {


		my $nmaprun = $XML->{"nmaprun"};

		my @host = @{$nmaprun->{"host"}};

		foreach(@host) {

			$counter++;
			my @address = @{$_->{"address"}};

			foreach my $addr (@address) {
				if($addr->{addrtype} eq "ipv4") {
					print "Found Host: $addr->{addr}";
				}
				if($addr->{addrtype} eq "mac") {
					print " $addr->{addr} ($addr->{vendor})\n";
				} 
			
			}
		}
		
		unlink($output);
		
		return 1;		

	} else {
		return 0;
	}
}

# /end functions
#####################################################################

print "  ============ <nmap plugin> ==============\n";

getopts ("b:e:i:n:r:s:v:");
if(    (!defined $opt_b) || (!defined $opt_i) 
    || (!defined $opt_n) || (!defined $opt_s) 
    || (!defined $opt_v) || (!defined $opt_e)) {
	print "  [!] This is intended to be run as a wicrawl plugin...\n";
	print "  [!] usage $0 <options>\n";
	print "\t-b <bssid>\n";
	print "\t-e <encryption>\n";
	print "\t-i <interface>\n";
	print "\t-n <nickname>\n";
	print "\t-s <ssid>\n";
	print "\t-v <version>\n";
	exit 1;
}


$bssid =     $opt_b if(defined $opt_b);
$encryption =$opt_e if(defined $opt_e);
$ssid =      $opt_s if(defined $opt_s);
$interface = $opt_i if(defined $opt_i);
$nick =      $opt_n if(defined $opt_n);
$version =   $opt_v if(defined $opt_v);

# TODO: get lan ip from the plugin-engine
$ip = &get_ip;

if($ip) {
	# verify we can find nmap
	$nmap=`which nmap 2>/dev/null`;
	chomp($nmap);
	if($nmap eq "" ) {
		print "  [!] Can't find nmap in path... exiting...\n";
		exit 1;
	}

	$rc = &nmap_exec;
} else {
	print " [!] Can't find local IP address... exiting..\n";
	$rc = 0;
}
my $lastmsg="  =========== </nmap plugin > ==============\n";
if($rc==1) {
	print "  [*] found $counter host(s) on $interface!...\n";
	print $lastmsg;
	exit 8;
} else {
	print "  [!] failed to perform scan on $interface...\n";
	print $lastmsg;
	exit 1;
}

exit 0;
