/*
 * dinject v0.1 [dinject-reasresp.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <libwnet.h>

#include "dinject.h"

#define BANNER \
 "* dinject-reasresp v0.1 by h1kari <h1kari@dachb0den.com> *\n" \
 "* Copyright (c) Dachb0den Labs 2002 [http://dachb0den.com] *\n"

extern int flags;

void
usage(char *progname)
{
  printf("\n%s\n", BANNER);
  printf("usage: %s <device> [-v] [options]\n\n", progname);
  _80211_usage();
  reasresp_usage();
  srates_usage();
  printf("\n");

  exit(2);
}

#define PKT_SIZE 4096
int
main(int argc, char *argv[])
{
  int c, off = 0;
  char *dev;
  u_char *pkt;
  struct wi_frame _80211_hdr;
  struct wi_mgmt_reasresp_hdr reasresp_hdr;
  struct wi_mgmt_var_hdr srates_hdr;
  flags = USE_SRATES;

  if (argc < 2)
    usage(argv[0]);

  dev = argv[1];

  _80211_hdr = _80211_defaults();
  reasresp_hdr = reasresp_defaults();
  srates_hdr = srates_defaults();

  _80211_hdr.wi_frame_ctl |= IEEE80211_FC0_TYPE_MGT |
   IEEE80211_FC0_SUBTYPE_REASSOC_RESP;
  verbose = 0;

  while ((c = getopt(argc - 1, argv + 1, BASE_OPT _80211_OPT REASRESP_OPT
   SRATES_OPT)) != EOF)
  {
    switch(c)
    {
      BASE_SETOPT()
      _80211_SETOPT(&_80211_hdr)
      REASRESP_SETOPT(&reasresp_hdr)
      SRATES_SETOPT(&srates_hdr)
      default:
        break;
    }
  }

  pkt = (u_char *)malloc(PKT_SIZE);

  off += _80211_WRITE(_80211_hdr, pkt + off, PKT_SIZE - off);
  off += REASRESP_WRITE(reasresp_hdr, pkt + off, PKT_SIZE - off);

  if(flags & USE_SRATES)
  {
    off += SRATES_WRITE(srates_hdr, pkt + off, PKT_SIZE - off);
  }

  _80211_INJECT(dev, pkt, off);

  exit(0);
}
