/*
 * dinject v0.1 [dinject.h]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <libwnet.h>

#define USE_SSID 0x01
#define USE_SRATES 0x02
#define USE_FHPARM 0x04
#define USE_DSPARM 0x08
#define USE_CFPARM 0x10
#define USE_TIM 0x20
#define USE_IBSSPARM 0x40
#define USE_CHALL 0x80
#define USE_WEP 0x100

#define BASE_OPT "v"
#define BASE_SETOPT() \
  case 'v': \
    printf("\n%s\n", BANNER); \
    verbose++; \
    break;

#define _80211_OPT "f:d:1:2:3:n:s:4:"
#define _80211_SETOPT(x) \
  case 'f': case 'd': case '1': case '2': \
  case '3': case 'n': case 's': case '4': \
    _80211_setopt(x, c, optarg); \
    break;

#define SNAP_OPT "N:t:"
#define SNAP_SETOPT(x) \
  case 'N': case 't': \
    snap_setopt(x, c, optarg); \
    break;
#define DATA_OPT "p:"
#define DATA_SETOPT(x) \
  case 'p': \
    data_setopt(x, c, optarg); \
    break;
#define WEP_OPT "wi:k:I:"
#define WEP_SETOPT(x) \
  case 'w': case 'i': case 'k': case 'I': \
    wep_setopt(x, c, optarg); \
    break;

#define BEACON_OPT "i:c:"
#define BEACON_SETOPT(x) \
  case 'i': case 'c': \
    beacon_setopt(x, c, optarg); \
    break;
#define DISAS_OPT "r:"
#define DISAS_SETOPT(x) \
  case 'r': \
    disas_setopt(x, c, optarg); \
    break;
#define ASREQ_OPT "c:i:"
#define ASREQ_SETOPT(x) \
  case 'c': case 'i': \
    asreq_setopt(x, c, optarg); \
    break;
#define ASRESP_OPT "c:S:a:"
#define ASRESP_SETOPT(x) \
  case 'c': case 'S': case 'a': \
    asresp_setopt(x, c, optarg); \
    break;
#define REASREQ_OPT "c:i:C:"
#define REASREQ_SETOPT(x) \
  case 'c': case 'i': case 'C': \
    reasreq_setopt(x, c, optarg); \
    break;
#define REASRESP_OPT "c:S:a:"
#define REASRESP_SETOPT(x) \
  case 'c': case 'S': case 'a': \
    reasresp_setopt(x, c, optarg); \
    break;
#define PROBERESP_OPT "i:c:"
#define PROBERESP_SETOPT(x) \
  case 'i': case 'c': \
    proberesp_setopt(x, c, optarg); \
    break;
#define AUTH_OPT "a:t:S:"
#define AUTH_SETOPT(x) \
  case 'a': case 't': case 'S': \
    auth_setopt(x, c, optarg); \
    break;
#define DEAUTH_OPT "r:"
#define DEAUTH_SETOPT(x) \
  case 'r': \
    deauth_setopt(x, c, optarg); \
    break;

#define SSID_OPT "S:"
#define SSID_SETOPT(x) \
  case 'S': \
    ssid_setopt(x, c, optarg); \
    break;
#define SRATES_OPT "r:"
#define SRATES_SETOPT(x) \
  case 'r': \
    srates_setopt(x, c, optarg); \
    break;
#define FHPARM_OPT "Fu:h:p:x:"
#define FHPARM_SETOPT(x) \
  case 'F': case 'u': case 'h': case 'p': case 'x': \
    fhparm_setopt(x, c, optarg); \
    break;
#define DSPARM_OPT "DH:"
#define DSPARM_SETOPT(x) \
  case 'D': case 'H': \
    dsparm_setopt(x, c, optarg); \
    break;
#define CFPARM_OPT "Co:e:m:R:"
#define CFPARM_SETOPT(x) \
  case 'C': case 'o': case 'e': case 'm': case 'R': \
    cfparm_setopt(x, c, optarg); \
    break;
#define TIM_OPT "tO:E:b:V:"
#define TIM_SETOPT(x) \
  case 't': case 'O': case 'E': case 'b': case 'V': \
    tim_setopt(x, c, optarg); \
    break;
#define IBSSPARM_OPT "Iw:"
#define IBSSPARM_SETOPT(x) \
  case 'I': case 'w': \
    ibssparm_setopt(x, c, optarg); \
    break; 
#define CHALL_OPT "A:"
#define CHALL_SETOPT(x) \
  case 'A': \
    chall_setopt(x, c, optarg); \
    break;

#define CAPINFO_SETOPT(x) \
  case 'c': \
    capinfo_setopt(x, c, optarg); \
    break;

#define _80211_WRITE(hdr, pkt, len) \
  build_80211(hdr.wi_frame_ctl, hdr.wi_id, hdr.wi_addr1, hdr.wi_addr2, \
   hdr.wi_addr3, hdr.wi_seq_ctl, hdr.wi_addr4, pkt, len); \
  if(verbose) printf("writing 802.11 header..\n")

#define SNAP_WRITE(hdr, pkt, len) \
  build_snap(hdr.wi_dat, hdr.wi_type, pkt, len); \
  if(verbose) printf("writing snap header..\n")
#define DATA_WRITE(hdr, pkt, len) \
  build_data(hdr.wi_data, hdr.wi_len, pkt, len); \
  if(verbose) printf("writing data..\n")
#define WEP_HDR_WRITE(hdr, pkt, len) \
  build_wep_hdr(hdr.wi_iv, hdr.wi_wep_id, buf, len); \
  if(verbose) printf("writing wep header..\n")
#define WEP_WRITE(hdr, buf, buf_off, pkt, len) \
  build_wep(buf, buf_off, hdr.wi_iv, hdr.wi_wep_len + 3, pkt, len); \
  if(verbose) printf("writing wep encrypted data..\n")
#define FCS_WRITE(buf, buf_off, pkt, len) \
  build_fcs(buf, buf_off, pkt, len); \
  if(verbose) printf("calculating and writing fcs checksum..\n")

#define BEACON_WRITE(hdr, pkt, len) \
  build_mgmt_beacon(hdr.wi_ts0, hdr.wi_ts1, hdr.wi_interval, hdr.wi_capinfo, \
   pkt, len); \
  if(verbose) printf("writing beacon header..\n")
#define DISAS_WRITE(hdr, pkt, len) \
  build_mgmt_disas(hdr.wi_reason, pkt, len); \
  if(verbose) printf("writing disas header..\n")
#define ASREQ_WRITE(hdr, pkt, len) \
  build_mgmt_asreq(hdr.wi_capinfo, hdr.wi_interval, pkt, len); \
  if(verbose) printf("writing asreq header..\n")
#define ASRESP_WRITE(hdr, pkt, len) \
  build_mgmt_asresp(hdr.wi_capinfo, hdr.wi_status, hdr.wi_aid, pkt, len); \
  if(verbose) printf("writing asresp header..\n")
#define REASREQ_WRITE(hdr, pkt, len) \
  build_mgmt_reasreq(hdr.wi_capinfo, hdr.wi_interval, hdr.wi_currap, pkt, \
   len); \
  if(verbose) printf("writing reasreq header..\n")
#define REASRESP_WRITE(hdr, pkt, len) \
  build_mgmt_reasresp(hdr.wi_capinfo, hdr.wi_status, hdr.wi_aid, pkt, len); \
  if(verbose) printf("writing reasresp header..\n")
#define PROBERESP_WRITE(hdr, pkt, len) \
  build_mgmt_proberesp(hdr.wi_ts0, hdr.wi_ts1, hdr.wi_interval, \
   hdr.wi_capinfo, pkt, len); \
  if(verbose) printf("writing proberesp header..\n")
#define AUTH_WRITE(hdr, pkt, len) \
  build_mgmt_auth(hdr.wi_algo, hdr.wi_seq, hdr.wi_status, pkt, len); \
  if(verbose) printf("writing auth header..\n")
#define DEAUTH_WRITE(hdr, pkt, len) \
  build_mgmt_deauth(hdr.wi_reason, pkt, len); \
  if(verbose) printf("writing deauth header..\n")

#define SSID_WRITE(hdr, pkt, len) \
  build_mgmt_field_ssid(hdr.wi_data, hdr.wi_len, pkt, len); \
  if(verbose) printf("writing ssid field..\n")
#define SRATES_WRITE(hdr, pkt, len) \
  build_mgmt_field_srates(hdr.wi_data, hdr.wi_len, pkt, len); \
  if(verbose) printf("writing srates field..\n")
#define FHPARM_WRITE(hdr, pkt, len) \
  build_mgmt_field_fhparm(*(u_short *)hdr.wi_data, hdr.wi_data[2], \
   hdr.wi_data[3], hdr.wi_data[4], pkt, len); \
  if(verbose) printf("writing fhparm field..\n")
#define DSPARM_WRITE(hdr, pkt, len) \
  build_mgmt_field_dsparm(hdr.wi_data[0], pkt, len); \
  if(verbose) printf("writing dsparm field..\n")
#define CFPARM_WRITE(hdr, pkt, len) \
  build_mgmt_field_cfparm(hdr.wi_data[0], hdr.wi_data[1], \
   *(u_short *)(hdr.wi_data + 2), *(u_short *)(hdr.wi_data + 4), pkt, len); \
  if(verbose) printf("writing cfparm field..\n")
#define TIM_WRITE(hdr, pkt, len) \
  build_mgmt_field_tim(hdr.wi_data[0], hdr.wi_data[1], hdr.wi_data[2], \
   hdr.wi_data + 3, hdr.wi_len - 3, pkt, len); \
  if(verbose) printf("writing tim field..\n")
#define IBSSPARM_WRITE(hdr, pkt, len) \
  build_mgmt_field_ibssparm(*(u_short *)hdr.wi_data, pkt, len); \
  if(verbose) printf("writing ibssparm field..\n")
#define CHALL_WRITE(hdr, pkt, len) \
  build_mgmt_field_chall(hdr.wi_data, hdr.wi_len, pkt, len); \
  if(verbose) printf("writing chall field..\n")

#define _80211_INJECT(dev, pkt, len) \
  inject_80211(dev, pkt, len); \
  if(verbose) printf("injecting packet!\n\n")


int verbose;

struct wi_snap_hdr {
  u_short wi_dat[3];
  u_short wi_type;
};

#define DATA_SIZE 4096
struct wi_data_hdr {
  u_char wi_data[DATA_SIZE];
  size_t wi_len;
};

#define IV_SIZE 3
#define KEY_SIZE 29
struct wi_wep_hdr {
  u_char wi_iv[IV_SIZE];
  u_char wi_key[KEY_SIZE];
  u_char wi_wep_len;
  u_char wi_wep_id;
};


#define DINJECT_MKPROTO(x, y) \
  void x##_usage(void); \
  y x##_defaults(void); \
  void x##_setopt(y *, int, char *)

/*
 * proto_80211.c
 */
DINJECT_MKPROTO(_80211, struct wi_frame);

/*
 * proto_data.c
 */
DINJECT_MKPROTO(snap, struct wi_snap_hdr);
DINJECT_MKPROTO(data, struct wi_data_hdr);
DINJECT_MKPROTO(wep, struct wi_wep_hdr);

/*
 * proto_mgmt.c
 */
DINJECT_MKPROTO(beacon, struct wi_mgmt_beacon_hdr);
DINJECT_MKPROTO(disas, struct wi_mgmt_disas_hdr);
DINJECT_MKPROTO(asreq, struct wi_mgmt_asreq_hdr);
DINJECT_MKPROTO(asresp, struct wi_mgmt_asresp_hdr);
DINJECT_MKPROTO(reasreq, struct wi_mgmt_reasreq_hdr);
DINJECT_MKPROTO(reasresp, struct wi_mgmt_reasresp_hdr);
DINJECT_MKPROTO(proberesp, struct wi_mgmt_proberesp_hdr);
DINJECT_MKPROTO(auth, struct wi_mgmt_auth_hdr);
DINJECT_MKPROTO(deauth, struct wi_mgmt_deauth_hdr);

/*
 * proto_mgmt_fields.c
 */
DINJECT_MKPROTO(ssid, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(srates, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(fhparm, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(dsparm, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(cfparm, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(tim, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(ibssparm, struct wi_mgmt_var_hdr);
DINJECT_MKPROTO(chall, struct wi_mgmt_var_hdr);

DINJECT_MKPROTO(capinfo, u_short);

/*
 * proto_misc.c
 */
void maccpy(u_char *, char *);
size_t hexcpy(u_char *, char *, size_t);
size_t keycpy(u_char *, char *, size_t);
