/*
 * dinject v0.1 [proto_80211.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libwnet.h>

#include "dinject.h"

void
_80211_usage(void)
{
  printf(" 802.11 options:\n"
   "  -f <frame ctl options>\n"
   "    t: to ds\n"
   "    f: from ds\n"
   "    m: more fragments\n"
   "    r: retry\n"
   "    p: power management\n"
   "    m: more data\n"
   "    w: wep\n"
   "    o: order by\n"
   "  -d <duration id>\n"
   "  -1 <addr 1>\n"
   "  -2 <addr 2>\n"
   "  -3 <addr 3>\n"
   "  -n <fragment number>\n"
   "  -s <sequence number>\n"
   "  -4 <addr 4>\n\n");
}

struct wi_frame
_80211_defaults(void)
{
  struct wi_frame hdr;

  hdr.wi_frame_ctl = IEEE80211_FC0_VERSION_0;
  hdr.wi_id = 0x8000;
  bzero(hdr.wi_addr1, 6);
  bzero(hdr.wi_addr2, 6);
  bzero(hdr.wi_addr3, 6);
  hdr.wi_seq_ctl = 0;
  bzero(hdr.wi_addr4, 6);

  return (hdr);
}

void
_80211_setopt(struct wi_frame *hdr, int opt, char *optarg)
{
  int i;

  switch(opt)
  {
    case 'f':
      for(i = 0; i < strlen(optarg); i++)
        switch(optarg[i])
        {
          case 't':
            hdr->wi_frame_ctl |= IEEE80211_FC1_DIR_TODS;
            break;
          case 'f':
            hdr->wi_frame_ctl |= IEEE80211_FC1_DIR_FROMDS;
            break;
          case 'm':
            hdr->wi_frame_ctl |= IEEE80211_FC1_MORE_FRAG;
            break;
          case 'r':
            hdr->wi_frame_ctl |= IEEE80211_FC1_RETRY;
            break;
          case 'p':
            hdr->wi_frame_ctl |= IEEE80211_FC1_PWR_MGT;
            break;
          case 'd':
            hdr->wi_frame_ctl |= IEEE80211_FC1_MORE_DATA;
            break;
          case 'w':
            hdr->wi_frame_ctl |= IEEE80211_FC1_WEP;
            break;
          case 'o':
            hdr->wi_frame_ctl |= IEEE80211_FC1_ORDER;
            break;
          default:
            break;
        }
      break;
    case 'd':
      hdr->wi_id = atoi(optarg) & 0xffff;
      break;
    case '1':
      maccpy(hdr->wi_addr1, optarg);
      break;
    case '2':
      maccpy(hdr->wi_addr2, optarg);
      break;
    case '3':
      maccpy(hdr->wi_addr3, optarg);
      break;
    case 'n':
      hdr->wi_seq_ctl |= (atoi(optarg) & 0xf);
      break;
    case 's':
      hdr->wi_seq_ctl |= (atoi(optarg) & 0xfff0);
      break;
    case '4':
      maccpy(hdr->wi_addr4, optarg);
      break;
    default:
      break;
  }
}
