/*
 * dinject v0.1 [proto_data.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#include <libwnet.h>

#include "dinject.h"

int flags;

void
snap_usage(void)
{
  printf(" snap options:\n"
   "  -N <snap data>\n"
   "  -t <type>\n\n");
}

struct wi_snap_hdr
snap_defaults(void)
{
  struct wi_snap_hdr hdr;

  hdr.wi_dat[0] = 0xaaaa;
  hdr.wi_dat[1] = 0x0300;
  hdr.wi_dat[2] = 0x0000;
  hdr.wi_type = 0x08;

  return (hdr);
}

void
snap_setopt(struct wi_snap_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'N':
      hexcpy((u_char *)hdr->wi_dat, optarg, 6);
      break;
    case 't':
      hdr->wi_type = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
data_usage(void)
{
  printf(" data options:\n"
   "  -p <payload file>\n\n");
}

struct wi_data_hdr
data_defaults(void)
{
  struct wi_data_hdr hdr;

  bzero(hdr.wi_data, DATA_SIZE);
  hdr.wi_len = 0;

  return (hdr);
}

void
data_setopt(struct wi_data_hdr *hdr, int c, char *optarg)
{
  int fd;

  if(c != 'p')
    return;

  if((fd = open(optarg, O_RDONLY, 0644)) == -1)
  {
    perror("unable to open file");
    exit(2);
  }

  if((hdr->wi_len = read(fd, hdr->wi_data, DATA_SIZE)) == -1)
  {
    perror("unable to read from file");
    exit(2);
  }

  return;
}

void
wep_usage(void)
{
  printf(" wep options:\n"
   "  %s-w: use wep encryption%s\n"
   "    -i <iv>\n"
   "    -k <key>\n"
   "    -I <key id>\n\n", flags & USE_WEP ? "" : "[",
   flags & USE_WEP ? "" : "]");
}

struct wi_wep_hdr
wep_defaults(void)
{
  struct wi_wep_hdr hdr;

  memcpy(hdr.wi_iv, "\x03\xff\x00", IV_SIZE);
  memcpy(hdr.wi_key, "\x01\x23\x45\x67\x89", KEY_SIZE);
  hdr.wi_wep_len = 5;
  hdr.wi_wep_id = 0;

  return (hdr);
}

void
wep_setopt(struct wi_wep_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'w':
      flags |= USE_WEP;
      break;
    case 'i':
      keycpy(hdr->wi_iv, optarg, IV_SIZE);
      break;
    case 'k':
      hdr->wi_wep_len = keycpy(hdr->wi_key, optarg, KEY_SIZE);
      break;
    case 'I':
      hdr->wi_wep_id = atoi(optarg) & 0xff;
      break;
    default:
      break;
  }
}
