/*
 * dinject v0.1 [proto_mgmt.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libwnet.h>

#include "dinject.h"

void
beacon_usage(void)
{
  printf(" beacon options:\n"
   "  -i <interval>\n");
  capinfo_usage();
}

struct wi_mgmt_beacon_hdr
beacon_defaults(void)
{
  struct wi_mgmt_beacon_hdr hdr;

  hdr.wi_ts0 = 0;
  hdr.wi_ts1 = 0;
  hdr.wi_interval = 100;
  hdr.wi_capinfo = capinfo_defaults();

  return (hdr);
}

void
beacon_setopt(struct wi_mgmt_beacon_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'i':
      hdr->wi_interval = atoi(optarg) & 0xffff;
      break;
    CAPINFO_SETOPT(&hdr->wi_capinfo);
    default:
      break;
  }
}

void
disas_usage(void)
{
  printf(" disas options:\n"
   "  -r <reason>\n");
}

struct wi_mgmt_disas_hdr
disas_defaults(void)
{
  struct wi_mgmt_disas_hdr hdr;

  hdr.wi_reason = IEEE80211_REASON_UNSPECIFIED;

  return (hdr);
}

void
disas_setopt(struct wi_mgmt_disas_hdr *hdr, int c, char *optarg)
{
  if(c != 'r')
    return;

  hdr->wi_reason = atoi(optarg) & 0xffff;
}

void
asreq_usage(void)
{
  printf(" asreq options:\n");
  capinfo_usage();
  printf("  -i <listen interval>\n");
}

struct wi_mgmt_asreq_hdr
asreq_defaults(void)
{
  struct wi_mgmt_asreq_hdr hdr;

  hdr.wi_capinfo = capinfo_defaults();
  hdr.wi_interval = 100;

  return (hdr);
}

void
asreq_setopt(struct wi_mgmt_asreq_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    CAPINFO_SETOPT(&hdr->wi_capinfo);
    case 'i':
      hdr->wi_interval = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
asresp_usage(void)
{
  printf(" asresp options:\n");
  capinfo_usage();
  printf("  -S <status code>\n"
   "  -a <association id>\n");
}

struct wi_mgmt_asresp_hdr
asresp_defaults(void)
{
  struct wi_mgmt_asresp_hdr hdr;

  hdr.wi_capinfo = capinfo_defaults();
  hdr.wi_status = IEEE80211_STATUS_UNSPECIFIED;
  hdr.wi_aid = 0;

  return (hdr);
}

void
asresp_setopt(struct wi_mgmt_asresp_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    CAPINFO_SETOPT(&hdr->wi_capinfo);
    case 'S':
      hdr->wi_status = atoi(optarg) & 0xffff;
      break;
    case 'a':
      hdr->wi_aid = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
reasreq_usage(void)
{
  printf(" reasreq options:\n");
  capinfo_usage();
  printf("  -i <listen interval>\n"
   "  -C <current ap addr>\n");
}

struct wi_mgmt_reasreq_hdr
reasreq_defaults(void)
{
  struct wi_mgmt_reasreq_hdr hdr;

  hdr.wi_capinfo = capinfo_defaults();
  hdr.wi_interval = 100;
  bzero(hdr.wi_currap, 6);

  return (hdr);
}

void
reasreq_setopt(struct wi_mgmt_reasreq_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    CAPINFO_SETOPT(&hdr->wi_capinfo);
    case 'i':
      hdr->wi_interval = atoi(optarg) & 0xffff;
      break;
    case 'C':
      maccpy(hdr->wi_currap, optarg);
      break;
    default:
      break;
  }
}

void
reasresp_usage(void)
{
  printf(" reasresp options:\n");
  capinfo_usage();
  printf("  -S <status code>\n"
   "  -a <association id>\n");
}

struct wi_mgmt_reasresp_hdr
reasresp_defaults(void)
{
  struct wi_mgmt_reasresp_hdr hdr;

  hdr.wi_capinfo = capinfo_defaults();
  hdr.wi_status = IEEE80211_STATUS_UNSPECIFIED;
  hdr.wi_aid = 0;

  return (hdr);
}

void
reasresp_setopt(struct wi_mgmt_reasresp_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    CAPINFO_SETOPT(&hdr->wi_capinfo);
    case 'S':
      hdr->wi_status = atoi(optarg) & 0xffff;
      break;
    case 'a':
      hdr->wi_status = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
proberesp_usage(void)
{
  printf(" proberesp options:\n"
   "  -i <interval>\n");
  capinfo_usage();
}

struct wi_mgmt_proberesp_hdr
proberesp_defaults(void)
{
  struct wi_mgmt_proberesp_hdr hdr;

  hdr.wi_ts0 = 0;
  hdr.wi_ts1 = 0;
  hdr.wi_interval = 100;
  hdr.wi_capinfo = capinfo_defaults();

  return (hdr);
}

void
proberesp_setopt(struct wi_mgmt_proberesp_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'i':
      hdr->wi_interval = atoi(optarg) & 0xffff;
      break;
    CAPINFO_SETOPT(&hdr->wi_capinfo);
    default:
      break;
  }
}

void
auth_usage(void)
{
  printf(" auth options:\n"
   "  -a <algorithm number>\n"
   "  -t <transaction sequence number>\n"
   "  -S <status code>\n");
}

struct wi_mgmt_auth_hdr
auth_defaults(void)
{
  struct wi_mgmt_auth_hdr hdr;

  hdr.wi_algo = IEEE80211_AUTH_ALG_OPEN;
  hdr.wi_seq = 0;
  hdr.wi_status = IEEE80211_STATUS_UNSPECIFIED;

  return (hdr);
}

void
auth_setopt(struct wi_mgmt_auth_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'a':
      hdr->wi_algo = atoi(optarg) & 0xffff;
      break;
    case 't':
      hdr->wi_seq = atoi(optarg) & 0xffff;
      break;
    case 'S':
      hdr->wi_status = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
deauth_usage(void)
{
  printf(" deauth options:\n"
   "  -r <reason>\n");
}

struct wi_mgmt_deauth_hdr
deauth_defaults(void)
{
  struct wi_mgmt_deauth_hdr hdr;

  hdr.wi_reason = IEEE80211_REASON_UNSPECIFIED;

  return (hdr);
}

void
deauth_setopt(struct wi_mgmt_deauth_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'r':
      hdr->wi_reason = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}
