/*
 * dinject v0.1 [proto_mgmt_fields.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libwnet.h>

#include "dinject.h"

int flags;

void
ssid_usage(void)
{
  printf("  %s-S <ssid>%s\n", flags & USE_SSID ? "" : "[",
   flags & USE_SSID ? "" : "]");
}

struct wi_mgmt_var_hdr
ssid_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_SSID;
  hdr.wi_len = 7;
  memcpy(hdr.wi_data, "default", 7);

  return (hdr);
}

void
ssid_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  if(c != 'S')
    return;

  flags |= USE_SSID;

  hdr->wi_len = strlen(optarg);
  memcpy(hdr->wi_data, optarg, hdr->wi_len);
}

void
srates_usage(void)
{
  printf("  %s-r <supported rates>%s\n", flags & USE_SRATES ? "" : "[",
   flags & USE_SRATES ? "" : "]");
}

struct wi_mgmt_var_hdr
srates_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_RATES;
  hdr.wi_len = 4;
  memcpy(hdr.wi_data, "\x82\x84\x8b\x96", 4);

  return (hdr);
}

void
srates_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  int maj, min, i = 0;
  char *ptr;

  if(c != 'r')
    return;

  flags |= USE_SRATES;

  ptr = optarg;
  do
  {
    maj = min = 0;
    sscanf(ptr, "%d.%d ", &maj, &min);
    hdr->wi_data[i++] = (((maj * 2) + (min / 5)) | 0x80) & 0xff;
  }
  while((ptr = strchr(ptr, ' ')) != NULL && ptr++);

  hdr->wi_len = i;
}

void
fhparm_usage(void)
{
  printf("  %s-F: fhss parameters%s\n"
   "    -u <dwell time>\n"
   "    -h <hop set>\n"
   "    -p <hop pattern>\n"
   "    -x <hop index>\n", flags & USE_FHPARM ? "" : "[",
   flags & USE_FHPARM ? "" : "]");
}

struct wi_mgmt_var_hdr
fhparm_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_FHPARMS;
  hdr.wi_len = 5;
  *(u_short *)hdr.wi_data = 0;
  hdr.wi_data[2] = 0;
  hdr.wi_data[3] = 0;
  hdr.wi_data[4] = 0;

  return (hdr);
}

void
fhparm_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'F':
      flags |= USE_FHPARM;
      break;
    case 'u':
      *(u_short *)hdr->wi_data = atoi(optarg) & 0xffff;
      break;
    case 'h':
      hdr->wi_data[2] = atoi(optarg) & 0xff;
      break;
    case 'p':
      hdr->wi_data[3] = atoi(optarg) & 0xff;
      break;
    case 'x':
      hdr->wi_data[4] = atoi(optarg) & 0xff;
      break;
    default:
      break;
  }
}

void
dsparm_usage(void)
{
  printf("  %s-D: dsss parameters%s\n"
   "    -H <channel>\n", flags & USE_DSPARM ? "" : "[",
   flags & USE_DSPARM ? "" : "]");
}

struct wi_mgmt_var_hdr
dsparm_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_DSPARMS;
  hdr.wi_len = 1;
  hdr.wi_data[0] = 6;

  return (hdr);
}

void
dsparm_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'D':
      flags |= USE_DSPARM;
      break;
    case 'H':
      hdr->wi_data[0] = atoi(optarg) & 0xff;
      break;
    default:
      break;
  }
}

void
cfparm_usage(void)
{
  printf("  %s-C: cf parameters%s\n"
   "    -o <cfp count>\n"
   "    -e <cfp period>\n"
   "    -m <cfp max duration>\n"
   "    -R <cfp duration remaining>\n", flags & USE_CFPARM ? "" : "[",
   flags & USE_CFPARM ? "" : "]");
}

struct wi_mgmt_var_hdr
cfparm_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_CFPARMS;
  hdr.wi_len = 6;
  hdr.wi_data[0] = 0;
  hdr.wi_data[1] = 0;
  *(u_short *)(hdr.wi_data + 2) = 0;
  *(u_short *)(hdr.wi_data + 4) = 0;

  return (hdr);
}

void
cfparm_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'C':
      flags |= USE_CFPARM;
      break;
    case 'o':
      hdr->wi_data[0] = atoi(optarg) & 0xff;
      break;
    case 'e':
      hdr->wi_data[1] = atoi(optarg) & 0xff;
      break;
    case 'm':
      *(u_short *)(hdr->wi_data + 2) = atoi(optarg) & 0xffff;
      break;
    case 'R':
      *(u_short *)(hdr->wi_data + 4) = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
tim_usage(void)
{
  printf("  %s-t: tim%s\n"
   "    -O: dtim count\n"
   "    -E: dtim period\n"
   "    -b: bitmap control\n"
   "    -V: partial virtual bitmap\n", flags & USE_TIM ? "" : "[",
   flags & USE_TIM ? "" : "]");
}

struct wi_mgmt_var_hdr
tim_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_TIM;
  hdr.wi_len = 7;
  hdr.wi_data[0] = 0;
  hdr.wi_data[1] = 2;
  hdr.wi_data[2] = 0;
  memcpy(hdr.wi_data + 3, "\x0d\xfb\xf5\x65", 4);

  return (hdr);
}

void
tim_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 't':
      flags |= USE_TIM;
      break;
    case 'O':
      hdr->wi_data[0] = atoi(optarg) & 0xff;
      break;
    case 'E':
      hdr->wi_data[1] = atoi(optarg) & 0xff;
      break;
    case 'b':
      hdr->wi_data[2] = atoi(optarg) & 0xff;
      break;
    case 'V':
      hdr->wi_len = hexcpy(hdr->wi_data + 3, optarg, 253) + 3;
      break;
    default:
      break;
  }
}

void
ibssparm_usage(void)
{
  printf("  %s-I: ibss parameters%s\n"
   "    -w <atim window>\n", flags & USE_IBSSPARM ? "" : "[",
   flags & USE_IBSSPARM ? "" : "]");
}

struct wi_mgmt_var_hdr
ibssparm_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_IBSSPARMS;
  hdr.wi_len = 2;
  *(u_short *)hdr.wi_data = 0;

  return (hdr);
}

void
ibssparm_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  switch(c)
  {
    case 'I':
      flags |= USE_IBSSPARM;
      break;
    case 'w':
      *(u_short *)hdr->wi_data = atoi(optarg) & 0xffff;
      break;
    default:
      break;
  }
}

void
chall_usage(void)
{
  printf("  %s-A <challenge text>%s\n", flags & USE_CHALL ? "" : "[",
   flags & USE_CHALL ? "" : "]");
}

struct wi_mgmt_var_hdr
chall_defaults(void)
{
  struct wi_mgmt_var_hdr hdr;

  hdr.wi_code = IEEE80211_ELEMID_CHALLENGE;
  hdr.wi_len = 0;

  return (hdr);
}

void
chall_setopt(struct wi_mgmt_var_hdr *hdr, int c, char *optarg)
{
  if(c != 'A')
    return;

  flags |= USE_CHALL;
  hdr->wi_len = strlen(optarg);
  memcpy(hdr->wi_data, optarg, hdr->wi_len);
}

void
capinfo_usage(void)
{
  printf("  -c <capinfo options>\n"
   "    e: ess\n"
   "    i: ibss\n"
   "    a: cf pollable\n"
   "    r: cf pollreq\n"
   "    p: privacy\n");
}

u_short
capinfo_defaults(void)
{
  return (IEEE80211_CAPINFO_ESS);
}

void
capinfo_setopt(u_int16_t *capinfo, int c, char *optarg)
{
  int i;

  for(i = 0; i < strlen(optarg); i++)
    switch(optarg[i])
    { 
      case 'e':
        *capinfo |= IEEE80211_CAPINFO_ESS;
        break;
      case 'i':
        *capinfo |= IEEE80211_CAPINFO_IBSS;
        break;
      case 'a':
        *capinfo |= IEEE80211_CAPINFO_CF_POLLABLE;
        break;
      case 'r':
        *capinfo |= IEEE80211_CAPINFO_CF_POLLREQ;
        break;
      case 'p':
        *capinfo |= IEEE80211_CAPINFO_PRIVACY;
        break;
      default:
        break;
    }
}
