/*
 * dinject v0.1 [proto_misc.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*                                                                               * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.               *
 * Redistribution and use in source and binary forms, with or without            * modification, are permitted provided that the following conditions
 * are met:                                                                      * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.              * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.                * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *                                                                               * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE         * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF          * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)       * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <string.h>

#include <libwnet.h>

void
maccpy(u_char *mac, char *str)
{
  int i, tmp[6];

  bzero(tmp, sizeof(int) * 6);

  sscanf(str, "%02x:%02x:%02x:%02x:%02x:%02x",
   &tmp[0], &tmp[1], &tmp[2], &tmp[3], &tmp[4], &tmp[5]);
    

  for(i = 0; i < 6; i++)
    mac[i] = tmp[i] & 0xff;
}

size_t
hexcpy(u_char *data, char *str, size_t len)
{
  int i = 0, tmp;

  do
  {
    if(i > len) break;

    sscanf(str, "\\x%02x", &tmp);
    data[i++] = tmp & 0xff;
  }
  while((str = strchr(str, '\\')) != NULL);

  return (i);
}

size_t
keycpy(u_char *data, char *str, size_t len)
{
  int i = 0, tmp;

  if(str[0] != '0' || str[1] != 'x')
    return (0);

  str += 2;

  while(i < len && sscanf(str += 2, "%02x", &tmp))
    data[i++] = tmp & 0xff;

  return (i);
}
