/*
 * libwnet v0.1 [build_80211.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <sys/types.h>

#include <libwnet.h>

size_t
build_80211(u_short fctl, u_short did, u_char *addr1, u_char *addr2,
 u_char *addr3, u_short seqctl, u_char *addr4, u_char *pkt, size_t len)
{
  struct wi_frame *hdr;

  if(len < sizeof(struct wi_frame))
    return -1;

  hdr = (struct wi_frame *)pkt;
  memset((u_char *)hdr, 0, WI_802_3_OFFSET);

  hdr->wi_rate = 110;    /* 11mbit */
  hdr->wi_tx_rate = 110; /* 11mbit */
  hdr->wi_tx_ctl = htole16(WI_ENC_TX_MGMT);
  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_id = htole16(did);
  memcpy(hdr->wi_addr1, addr1, 6);
  memcpy(hdr->wi_addr2, addr2, 6);
  memcpy(hdr->wi_addr3, addr3, 6);
  hdr->wi_seq_ctl = htole16(seqctl);
  memcpy(hdr->wi_addr4, addr4, 6);

  return (WI_802_11_OFFSET_RAW);
}
