/*
 * libwnet v0.1 [build_ctrl.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <sys/types.h>

#include <libwnet.h>

size_t
build_ctrl_rts(u_short fctl, u_short did, u_char *ra, u_char *ta,
 u_char *pkt, size_t len)
{
  struct wi_ctrl_rts_hdr *hdr;

  if(len < sizeof(struct wi_ctrl_rts_hdr))
    return -1;

  hdr = (struct wi_ctrl_rts_hdr *)pkt;

  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_duration = htole16(did);
  memcpy(hdr->wi_ra, ra, 6);
  memcpy(hdr->wi_ta, ta, 6);

  return (sizeof(struct wi_ctrl_rts_hdr));
}

size_t
build_ctrl_cts(u_short fctl, u_short did, u_char *ra, u_char *pkt,
 size_t len)
{
  struct wi_ctrl_cts_hdr *hdr;

  if(len < sizeof(struct wi_ctrl_cts_hdr))
    return -1;

  hdr = (struct wi_ctrl_cts_hdr *)pkt;

  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_duration = htole16(did);
  memcpy(hdr->wi_ra, ra, 6);

  return (sizeof(struct wi_ctrl_cts_hdr));
}

size_t
build_ctrl_ack(u_short fctl, u_short did, u_char *ra, u_char *pkt,
 size_t len)
{
  struct wi_ctrl_ack_hdr *hdr;

  if(len < sizeof(struct wi_ctrl_ack_hdr))
    return -1;

  hdr = (struct wi_ctrl_ack_hdr *)pkt;

  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_duration = htole16(did);
  memcpy(hdr->wi_ra, ra, 6);

  return (sizeof(struct wi_ctrl_ack_hdr));
}

size_t
build_ctrl_pspoll(u_short fctl, u_short aid, u_char *bssid, u_char *ta,
 u_char *pkt, size_t len)
{
  struct wi_ctrl_pspoll_hdr *hdr;

  if(len < sizeof(struct wi_ctrl_pspoll_hdr))
    return -1;

  hdr = (struct wi_ctrl_pspoll_hdr *)pkt;

  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_aid = htole16(aid);
  memcpy(hdr->wi_bssid, bssid, 6);
  memcpy(hdr->wi_ta, ta, 6);

  return (sizeof(struct wi_ctrl_pspoll_hdr));
}

size_t
build_ctrl_cfend(u_short fctl, u_short did, u_char *ra, u_char *bssid,
 u_char *pkt, size_t len)
{
  struct wi_ctrl_cfend_hdr *hdr;

  if(len < sizeof(struct wi_ctrl_cfend_hdr))
    return -1;

  hdr = (struct wi_ctrl_cfend_hdr *)pkt;

  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_duration = htole16(did);
  memcpy(hdr->wi_ra, ra, 6);
  memcpy(hdr->wi_bssid, bssid, 6);

  return (sizeof(struct wi_ctrl_cfend_hdr));
}

size_t
build_ctrl_cfendcfack(u_short fctl, u_short did, u_char *ra, u_char *bssid,
 u_char *pkt, size_t len)
{
  struct wi_ctrl_cfendcfack_hdr *hdr;

  if(len < sizeof(struct wi_ctrl_cfendcfack_hdr))
    return -1;

  hdr = (struct wi_ctrl_cfendcfack_hdr *)pkt;

  hdr->wi_frame_ctl = htole16(fctl);
  hdr->wi_duration = htole16(did);
  memcpy(hdr->wi_ra, ra, 6);
  memcpy(hdr->wi_bssid, bssid, 6);

  return (sizeof(struct wi_ctrl_cfendcfack_hdr));
}
