/*
 * libwnet v0.1 [build_mgmt.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <sys/types.h>

#include <libwnet.h>

size_t
build_mgmt_beacon(u_long ts0, u_long ts1, u_short interval,
 u_short capinfo, u_char *pkt, size_t len)
{
  struct wi_mgmt_beacon_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_beacon_hdr))
    return -1;

  hdr = (struct wi_mgmt_beacon_hdr *)pkt;

  hdr->wi_ts0 = htole32(ts0);
  hdr->wi_ts1 = htole32(ts1);
  hdr->wi_interval = htole16(interval);
  hdr->wi_capinfo = htole16(capinfo);

  return (sizeof(struct wi_mgmt_beacon_hdr));
}

size_t
build_mgmt_atim(u_char *pkt, size_t len)
{
  return (0);
}

size_t
build_mgmt_disas(u_short reason, u_char *pkt, size_t len)
{
  struct wi_mgmt_disas_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_disas_hdr))
    return -1;

  hdr = (struct wi_mgmt_disas_hdr *)pkt;

  hdr->wi_reason = htole16(reason);

  return (sizeof(struct wi_mgmt_disas_hdr));
}

size_t
build_mgmt_asreq(u_short capinfo, u_short interval, u_char *pkt,
 size_t len)
{
  struct wi_mgmt_asreq_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_asreq_hdr))
    return -1;

  hdr = (struct wi_mgmt_asreq_hdr *)pkt;

  hdr->wi_capinfo = htole16(capinfo);
  hdr->wi_interval = htole16(interval);

  return (sizeof(struct wi_mgmt_asreq_hdr));
}

size_t
build_mgmt_asresp(u_short capinfo, u_short status, u_short aid,
 u_char *pkt, size_t len)
{
  struct wi_mgmt_asresp_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_asresp_hdr))
    return -1;

  hdr = (struct wi_mgmt_asresp_hdr *)pkt;

  hdr->wi_capinfo = htole16(capinfo);
  hdr->wi_status = htole16(status);
  hdr->wi_aid = htole16(aid);

  return (sizeof(struct wi_mgmt_asresp_hdr));
}

size_t
build_mgmt_reasreq(u_short capinfo, u_short interval, u_char *cap,
 u_char *pkt, size_t len)
{
  struct wi_mgmt_reasreq_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_reasreq_hdr))
    return -1;

  hdr = (struct wi_mgmt_reasreq_hdr *)pkt;

  hdr->wi_capinfo = htole16(capinfo);
  hdr->wi_interval = htole16(interval);
  memcpy(hdr->wi_currap, cap, 6);

  return (sizeof(struct wi_mgmt_reasreq_hdr));
}

size_t
build_mgmt_reasresp(u_short capinfo, u_short status, u_short aid,
 u_char *pkt, size_t len)
{
  struct wi_mgmt_reasresp_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_reasresp_hdr))
    return -1;

  hdr = (struct wi_mgmt_reasresp_hdr *)pkt;

  hdr->wi_capinfo = htole16(capinfo);
  hdr->wi_status = htole16(status);
  hdr->wi_aid = htole16(aid);

  return (sizeof(struct wi_mgmt_reasresp_hdr));
}

size_t
build_mgmt_probereq(u_char *pkt, size_t len)
{
  return (0);
}

size_t
build_mgmt_proberesp(u_long ts0, u_long ts1, u_short interval,
 u_short capinfo, u_char *pkt, size_t len)
{
  struct wi_mgmt_proberesp_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_proberesp_hdr))
    return -1;

  hdr = (struct wi_mgmt_proberesp_hdr *)pkt;

  hdr->wi_ts0 = htole32(ts0);
  hdr->wi_ts1 = htole32(ts1);
  hdr->wi_interval = htole16(interval);
  hdr->wi_capinfo = htole16(capinfo);

  return (sizeof(struct wi_mgmt_proberesp_hdr));
}

size_t
build_mgmt_auth(u_short algo, u_short seq, u_short status, u_char *pkt,
 size_t len)
{
  struct wi_mgmt_auth_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_auth_hdr))
    return -1;

  hdr = (struct wi_mgmt_auth_hdr *)pkt;

  hdr->wi_algo = htole16(algo);
  hdr->wi_seq = htole16(seq);
  hdr->wi_status = htole16(status);

  return (sizeof(struct wi_mgmt_auth_hdr));
}

size_t
build_mgmt_deauth(u_short reason, u_char *pkt, size_t len)
{
  struct wi_mgmt_deauth_hdr *hdr;

  if(len < sizeof(struct wi_mgmt_deauth_hdr))
    return -1;

  hdr = (struct wi_mgmt_deauth_hdr *)pkt;

  hdr->wi_reason = htole16(reason);

  return (sizeof(struct wi_mgmt_deauth_hdr));
}
