/*
 * libwnet v0.1 [build_mgmt_fields.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <sys/types.h>

#include <libwnet.h>

size_t
build_mgmt_field_ssid(u_char *ssid, size_t ssid_len, u_char *pkt, size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < ssid_len + 2)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_SSID;
  hdr->wi_len = ssid_len;
  memcpy(hdr->wi_data, ssid, ssid_len);

  return (ssid_len + 2);
}

size_t
build_mgmt_field_srates(u_char *srates, size_t srates_len, u_char *pkt,
 size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < srates_len + 2)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_RATES;
  hdr->wi_len = srates_len;
  memcpy(hdr->wi_data, srates, srates_len);

  return (srates_len + 2);
}

size_t
build_mgmt_field_fhparm(u_short dtu, u_char hset, u_char hpattern,
 u_char hindex, u_char *pkt, size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < 7)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_FHPARMS;
  hdr->wi_len = 5;
  *(u_short *)hdr->wi_data = htole16(dtu);
  hdr->wi_data[2] = hset;
  hdr->wi_data[3] = hpattern;
  hdr->wi_data[4] = hindex;

  return (7);
}

size_t
build_mgmt_field_dsparm(u_char chan, u_char *pkt, size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < 3)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_DSPARMS;
  hdr->wi_len = 1;
  hdr->wi_data[0] = chan;

  return (3);
}

size_t
build_mgmt_field_cfparm(u_char count, u_char period, u_short mdtu,
 u_short drtu, u_char *pkt, size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < 8)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_CFPARMS;
  hdr->wi_len = 6;
  hdr->wi_data[0] = count;
  hdr->wi_data[1] = period;
  *(u_short *)(hdr->wi_data + 2) = htole16(mdtu);
  *(u_short *)(hdr->wi_data + 4) = htole16(drtu);

  return (8);
}

size_t
build_mgmt_field_tim(u_char count, u_char period, u_char bctrl,
 u_char *vbitmap, size_t vbitmap_len, u_char *pkt, size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < vbitmap_len + 5)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_TIM;
  hdr->wi_len = vbitmap_len + 3;
  hdr->wi_data[0] = count;
  hdr->wi_data[1] = period;
  hdr->wi_data[2] = bctrl;
  memcpy(hdr->wi_data + 3, vbitmap, vbitmap_len);

  return (vbitmap_len + 5);
}

size_t
build_mgmt_field_ibssparm(u_short win, u_char *pkt, size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < 4)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_IBSSPARMS;
  hdr->wi_len = 2;
  *(u_short *)hdr->wi_data = win;

  return (4);
}

size_t
build_mgmt_field_chall(u_char *chall, size_t chall_len, u_char *pkt,
 size_t len)
{
  struct wi_mgmt_var_hdr *hdr;

  if(len < chall_len + 2)
    return -1;

  hdr = (struct wi_mgmt_var_hdr *)pkt;

  hdr->wi_code = IEEE80211_ELEMID_CHALLENGE;
  hdr->wi_len = chall_len;
  memcpy(hdr->wi_data, chall, chall_len);

  return (chall_len + 2);
}
