/*
 * libwnet v0.1 [inject.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */                                                                             

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <unistd.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/ioctl.h>

#include "libwnet.h"


#define CALCDATLEN(pkt) \
 { \
   struct wi_frame *hdr; \
   hdr = (struct wi_frame *)pkt; \
   if(letoh16(hdr->wi_dat_len) == 0) { \
     if((letoh16(hdr->wi_frame_ctl) & WI_FCTL_FTYPE) == WI_FTYPE_DATA ? \
      letoh16(hdr->wi_frame_ctl) & WI_FCTL_WEP : 1) \
       hdr->wi_len = len - WI_802_11_OFFSET_RAW; \
     else \
       hdr->wi_len = len - WI_802_11_OFFSET; \
     hdr->wi_dat_len = htole16(hdr->wi_len); \
   } \
 }

size_t
inject_80211(char *iface, u_char *pkt, size_t len)
{
  struct ifreq ifr;
  struct wi_req wreq;
  int s;

  CALCDATLEN(pkt);
  wreq.wi_type = WI_RID_RAW_XMIT;
  wreq.wi_len = len;
  memcpy(wreq.wi_val, pkt, len);

  strncpy(ifr.ifr_name, iface, sizeof(ifr.ifr_name));
  ifr.ifr_data = (caddr_t)&wreq;

  if((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    return -1;

  if(ioctl(s, SIOCSWAVELAN, &ifr) == -1)
    return -1;

  close(s);

  return len;
}

size_t
inject_80211_start(char *iface, u_char *pkt, size_t len, u_int32_t tries,
 u_int32_t interval)
{
  struct ifreq ifr;
  struct wi_req wreq;
  int s;

  CALCDATLEN(pkt);
  wreq.wi_type = WI_RID_RAW_XMIT_START;
  wreq.wi_len = len;
  *(u_int32_t *)wreq.wi_val = tries;
  *(u_int32_t *)(wreq.wi_val + 2) = interval;
  memcpy((u_char *)wreq.wi_val + 8, pkt, len);

  strncpy(ifr.ifr_name, iface, sizeof(ifr.ifr_name));
  ifr.ifr_data = (caddr_t)&wreq;

  if((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    return -1;

  if(ioctl(s, SIOCSWAVELAN, &ifr) == -1)
    return -1;

  close(s);

  return len;
}

int
inject_80211_stop(char *iface)
{
  struct ifreq ifr;
  struct wi_req wreq;
  int s;

  wreq.wi_type = WI_RID_RAW_XMIT_STOP;
  wreq.wi_len = 0;
  strncpy(ifr.ifr_name, iface, sizeof(ifr.ifr_name));
  ifr.ifr_data = (caddr_t)&wreq;

  if((s = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    return -1;

  if(ioctl(s, SIOCSWAVELAN, &ifr) == -1)
    return -1;

  close(s);

  return 0;
}
