/*
 * libwnet v0.1 [libwnet.h]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LIBWNET_H
#define _LIBWNET_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if.h>
#include <netinet/if_ether.h>

#include <dev/ic/if_wi_ieee.h>
#include <dev/ic/if_wireg.h>
#include <net/if_ieee80211.h>

#include <libwnet/libwnet-structures.h>

/*
 * 802.11
 */
size_t build_80211(u_short, u_short, u_char *, u_char *, u_char *, u_short, u_char *, u_char *, size_t);

/*
 * control
 */
size_t build_ctrl_rts(u_short, u_short, u_char *, u_char *, u_char *, size_t);
size_t build_ctrl_cts(u_short, u_short, u_char *, u_char *, size_t);
size_t build_ctrl_ack(u_short, u_short, u_char *, u_char *, size_t);
size_t build_ctrl_pspoll(u_short, u_short, u_char *, u_char *, u_char *, size_t);
size_t build_ctrl_cfend(u_short, u_short, u_char *, u_char *, u_char *, size_t);
size_t build_ctrl_cfendcfack(u_short, u_short, u_char *, u_char *, u_char *, size_t);

/*
 * management
 */
size_t build_mgmt_beacon(u_long, u_long, u_short, u_short, u_char *, size_t);
size_t build_mgmt_atim(u_char *, size_t);
size_t build_mgmt_disas(u_short, u_char *, size_t);
size_t build_mgmt_asreq(u_short, u_short, u_char *, size_t);
size_t build_mgmt_asresp(u_short, u_short, u_short, u_char *, size_t);
size_t build_mgmt_reasreq(u_short, u_short, u_char *, u_char *, size_t);
size_t build_mgmt_reasresp(u_short, u_short, u_short, u_char *, size_t);
size_t build_mgmt_probereq(u_char *, size_t);
size_t build_mgmt_proberesp(u_long, u_long, u_short, u_short, u_char *, size_t);
size_t build_mgmt_auth(u_short, u_short, u_short, u_char *, size_t);
size_t build_mgmt_deauth(u_short, u_char *, size_t);

/*
 * management fields
 */
size_t build_mgmt_field_ssid(u_char *, size_t, u_char *, size_t);
size_t build_mgmt_field_srates(u_char *, size_t, u_char *, size_t);
size_t build_mgmt_field_fhparm(u_short, u_char, u_char, u_char, u_char *, size_t);
size_t build_mgmt_field_dsparm(u_char, u_char *, size_t);
size_t build_mgmt_field_cfparm(u_char, u_char, u_short, u_short, u_char *, size_t);
size_t build_mgmt_field_tim(u_char, u_char, u_char, u_char *, size_t, u_char *, size_t);
size_t build_mgmt_field_ibssparm(u_short, u_char *, size_t);
size_t build_mgmt_field_chall(u_char *, size_t, u_char *, size_t);

/*
 * data
 */
size_t build_snap(u_short *, u_short, u_char *, size_t);
size_t build_data(u_char *, size_t, u_char *, size_t);
size_t build_wep_hdr(u_char *, u_char, u_char *, size_t);
size_t build_wep(u_char *, size_t, u_char *, size_t, u_char *, size_t);
size_t build_fcs(u_char *, size_t, u_char *, size_t);

/*
 * inject
 */
size_t inject_80211(char *, u_char *, size_t);
size_t inject_80211_start(char *, u_char *, size_t, u_int32_t, u_int32_t);
int inject_80211_stop(char *);

#endif /* _LIBWNET_H */
