/*
 * bsd-airtools v0.2 - source-mods v0.2 [common.h]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LIBWNET_LIBWNET_STRUCTURES_H
#define _LIBWNET_LIBWNET_STRUCTURES_H

/*
 * management frame headers
 * note: all management frames consist of a static header and variable length
 * fields.
 */

/*
 * variable length field structure
 */
struct wi_mgmt_var_hdr {
	u_int8_t	wi_code;
	u_int8_t	wi_len;
	u_int8_t	wi_data[256];
};

/*
 * management beacon frame prefix
 */
struct wi_mgmt_beacon_hdr {
	u_int32_t	wi_ts0;
	u_int32_t	wi_ts1;
	u_int16_t	wi_interval;
	u_int16_t	wi_capinfo;
};

/*
 * ibss announcement traffic indication message (atim) frame
 * note: no parameters
 */

/*
 * management disassociation frame
 */
struct wi_mgmt_disas_hdr {
	u_int16_t	wi_reason;
};

/*
 * management association request frame prefix
 */
struct wi_mgmt_asreq_hdr {
	u_int16_t	wi_capinfo;
	u_int16_t	wi_interval;
};

/*
 * management association response frame prefix
 */
struct wi_mgmt_asresp_hdr {
	u_int16_t	wi_capinfo;
	u_int16_t	wi_status;
	u_int16_t	wi_aid;
};

/*
 * management reassociation request frame prefix
 */
struct wi_mgmt_reasreq_hdr {
	u_int16_t	wi_capinfo;
	u_int16_t	wi_interval;
	u_int8_t	wi_currap[6];
};

/*
 * management reassociation response frame prefix
 */
struct wi_mgmt_reasresp_hdr {
	u_int16_t	wi_capinfo;
	u_int16_t	wi_status;
	u_int16_t	wi_aid;
};

/*
 * management probe request frame prefix
 * note: no static parameters, only variable length
 */

/*
 * management probe response frame prefix
 */
struct wi_mgmt_proberesp_hdr {
	u_int32_t	wi_ts0;
	u_int32_t	wi_ts1;
	u_int16_t	wi_interval;
	u_int16_t	wi_capinfo;
};

/*
 * management authentication frame prefix
 */
struct wi_mgmt_auth_hdr {
	u_int16_t	wi_algo;
	u_int16_t	wi_seq;
	u_int16_t	wi_status;
};

/*
 * management deauthentication frame
 */
struct wi_mgmt_deauth_hdr {
	u_int16_t	wi_reason;
};

/*
 * control request to send frame
 */
struct wi_ctrl_rts_hdr {
	u_int16_t	wi_frame_ctl;
	u_int16_t	wi_duration;
	u_int8_t	wi_ra[6];
	u_int8_t	wi_ta[6];
};

/*
 * control clear to send frame
 */
struct wi_ctrl_cts_hdr {
	u_int16_t	wi_frame_ctl;
	u_int16_t	wi_duration;
	u_int16_t	wi_ra[6];
};

/*
 * control acknowledgement frame
 */
struct wi_ctrl_ack_hdr {
	u_int16_t	wi_frame_ctl;
	u_int16_t	wi_duration;
	u_int8_t	wi_ra[6];
};

/*
 * control power-save poll frame
 */
struct wi_ctrl_pspoll_hdr {
	u_int16_t	wi_frame_ctl;
	u_int16_t	wi_aid;
	u_int8_t	wi_bssid[6];
	u_int8_t	wi_ta[6];
};

/*
 * control cfend frame format
 */
struct wi_ctrl_cfend_hdr {
	u_int16_t	wi_frame_ctl;
	u_int16_t	wi_duration;
	u_int8_t	wi_ra[6];
	u_int8_t	wi_bssid[6];
};

/*
 * control cfend + cfack frame
 */
struct wi_ctrl_cfendcfack_hdr {
	u_int16_t	wi_frame_ctl;
	u_int16_t	wi_duration;
	u_int16_t	wi_ra[6];
	u_int16_t	wi_bssid[6];
};

#endif /* _LIBWNET_LIBWNET_STRUCTURES_H */
