#!/usr/bin/perl

use strict;

sub RecursiveDeinfect($);
my $path_to_cleaner = "./kill";
my $options_to_cleaner = "";
my $verbose;

if($ARGV[0] eq "-v") { $verbose = shift; }

$_ = $ARGV[0];
if(/detect/) {
   $options_to_cleaner = "1";
   print "Recursively detecting trojan starting in: ", $ARGV[1] || "/", "\n";
} elsif(/remove/) {
   $options_to_cleaner = "2";
   print "Recursively removing trojan starting in: ", $ARGV[1] || "/", "\n";
} elsif(/immune/) {
   $options_to_cleaner = "4";
   print "Recursively making all binaries starting in: ", $ARGV[1] || "/", "immune\n";
} else {
   print "usage: $0 [-v] mode [startdir]\n".
	 "where mode is one of the following:\n".
	 "\tdetect\t: Recursively detect trojan\n".
	 "\tremove\t: Recursively remove trojan if trojan is present.\n".
	 "\timmune\t: Recursively remove trojan if trojan is present.\n".
	 "\t      \t  Make all innocent binaries immune for future infection\n".
	 "The default startdir is /\n";
   exit(0);
}


RecursiveDeinfect($ARGV[1] || "/");

sub RecursiveDeinfect($) {
   my $startdir = shift;
   my $filename;
   my $ret;
 
   return unless(opendir(my $DH, $startdir));

   print "Checking $startdir for infected binaries..\n" if($verbose);
 
   while($filename = readdir($DH)) {
      next if($filename eq "." or $filename eq "..");
      next if(-l "$startdir/$filename");
      stat("$startdir/$filename");
      RecursiveDeinfect("$startdir/$filename") && next if(-d _);
      next unless(-f _ && -x _);
      $ret = qx($path_to_cleaner $options_to_cleaner '$startdir/$filename' 2>/dev/null);
      if($options_to_cleaner eq "1" && $ret =~ /much alive/m) {
         warn "$startdir/$filename: Trojan Detected.\n";
      } elsif($options_to_cleaner eq "2" && $ret =~ /trojan disabled/m) {
         warn "$startdir/$filename: Trojan Detected and Removed\n";
      }
   }
 
   closedir($DH);
}
