/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * 
 *
 */

/*
 * config.h is generated by configure.  It contains the results
 * of probing for features, options etc.  It should be the first
 * file included in your .cc file.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <fsk4_apco25_f.h>
#include <gr_io_signature.h>
#include <gr_math.h>




/*
 * Create a new instance of fsk4_apco25_f and return
 * a boost shared_ptr.  This is effectively the public constructor.
 */
fsk4_apco25_f_sptr fsk4_make_apco25_f (gr_msg_queue_sptr queue, int processing_flags)
{
  return fsk4_apco25_f_sptr (new fsk4_apco25_f ( queue, processing_flags));
}

/*
 * Specify constraints on number of input and output streams.
 * This info is used to construct the input and output signatures
 * (2nd & 3rd args to gr_block's constructor).  The input and
 * output signatures are used by the runtime system to
 * check that a valid number and type of inputs and outputs
 * are connected to this block.  In this case, we accept
 * only 1 input and 1 output.
 */
static const int MIN_IN = 1;	// mininum number of input streams
static const int MAX_IN = 1;	// maximum number of input streams
static const int MIN_OUT = 1;	// minimum number of output streams
static const int MAX_OUT = 1;	// maximum number of output streams

/*
 * The private constructor
 */
fsk4_apco25_f::fsk4_apco25_f (gr_msg_queue_sptr queue, int processing_flags)
  : gr_block ("apco25_f",
	      gr_make_io_signature (MIN_IN, MAX_IN, sizeof (float)),	
//	      gr_make_io_signature (MIN_OUT, MAX_OUT, sizeof (float))),
	      gr_make_io_signature ( 0, 0, 0 )  ),
    d_queue(queue)
{

  sym_counter = 0;


  reverse_polarity = false;
  if ((processing_flags & 0x01) != 0) reverse_polarity = true;

  iframer_buffer = 0;
  framer_state = 0;
  symbol_counter = 0;


//  set_history (NTAPS + 2);	// we need to look at the previous values covering

}

/*
 * Our virtual destructor.
 */
fsk4_apco25_f::~fsk4_apco25_f ()
{
  // nothing else required in this example
}




void  fsk4_apco25_f::forecast(int noutput_items, gr_vector_int &inputs_required)
{
    // given output request of noutput_items return number of input items required
    int items = noutput_items; 		// this is 1:1 stub
    for (unsigned int i = 0; i < inputs_required.size(); i++)  inputs_required[i] = items;   
}

// -------------------------------------------------------------------------------

int
fsk4_apco25_f::process_HDU(unsigned char *dd)
{
  int i;

  // TODO: Error correction


  // symbols 0-323 are HDU, 5 nulls should be starting at 324

  printf("HDU: ");

  for (i=0; i<5; i++) printf("%1i:",*(dd+i+324));
  printf("\n");

  return 0;
}

// -------------------------------------------------------------------------------

int
fsk4_apco25_f::process_NID(unsigned char *dd)
{

  // TODO: Error correction


  // for now we can extract embedded data with hassling with error correction
  // systematic error correction quite simply is the dog's bollocks for lazy people


  apco25_nid_nac = *(dd);
  apco25_nid_nac = (apco25_nid_nac << 2) | *(dd+1);
  apco25_nid_nac = (apco25_nid_nac << 2) | *(dd+2);
  apco25_nid_nac = (apco25_nid_nac << 2) | *(dd+3);
  apco25_nid_nac = (apco25_nid_nac << 2) | *(dd+4);
  apco25_nid_nac = (apco25_nid_nac << 2) | *(dd+5);


  apco25_nid_duid = *(dd+6);
  apco25_nid_duid = (apco25_nid_duid << 2) | *(dd+7);

  printf("Network Access Code: %03X\tData Unit ID %1X: %s\n",apco25_nid_nac, apco25_nid_duid, apco25_duid_str[apco25_nid_duid]);

  return 0;
}

// -------------------------------------------------------------------------------
//
void
fsk4_apco25_f::strip_status_syms(unsigned char sym)
{
  static int raw_symbol_counter = 0;

  if (sym == (unsigned char) 255)
  {
    // remember... this gets triggered when sync symbols 0..23 inclusive are detected; 
    // next symbol will be index 24
    raw_symbol_counter = 24;
    symbol_counter = 0;

// printf("\n");

    return;
  }

  

  if ( (raw_symbol_counter % 35) != 0)
  {
//    printf("%1i",sym);

    data_unit[symbol_counter] = sym;
    if (symbol_counter < 2047) symbol_counter++;

    // 32 symbols completes incoming NID; process to get length of reset of data unit
    if (symbol_counter == 32) process_NID(&data_unit[0]);

//    if ((symbol_counter == 361) && (apco25_nid_duid == 0)) process_HDU(&data_unit[32]);


  }
  else
  {
    // status bits are ostracized here

  }

  raw_symbol_counter++;

}



// -------------------------------------------------------------------------------
// first step: detect frame sync sequence.
// input data a stream of unsigned chars from set of 0, 1, 2, or 3
// this routine strips out frame sync and passes all further symbols to higher level 
void
fsk4_apco25_f::framer(unsigned char sym)
{
  int i,j, sync_mismatch;


  // framer_state 0 means waiting for sync sequence to appear 
  // (higher level routines can turn off feed as desired until resynced)
  if (framer_state != 0) strip_status_syms(sym);

  // place incoming sysmbol 
  framer_buffer[iframer_buffer] = sym;
  iframer_buffer = (iframer_buffer + 1) % NFRAMER_BUFFER_APCO25;

  sync_mismatch = 0;
  j = iframer_buffer;	// point to oldest sample in buffer
  for (i=0; i<LEN_APCO25_SYNC; i++)
  {
    if (framer_buffer[j] !=  apco25_sync[i]) sync_mismatch++;
    j = (j+1) % NFRAMER_BUFFER_APCO25;
  }

  if (sync_mismatch < 3)
  {
    strip_status_syms(255);		// signal reset 
    framer_state = 1;
  }

}



// -------------------------------------------------------------------------------
// take our stream of incoming floats, convert to symbols and pass upwards
//
// Probably will never happen:  implement soft decision decoding
//
int  
fsk4_apco25_f::general_work (int noutput_items,
			       gr_vector_int &ninput_items,
			       gr_vector_const_void_star &input_items,
			       gr_vector_void_star &output_items)
{
  unsigned char sym;


  float *in = (float *) input_items[0];
 
  float *out = (float *) output_items[0];


  // run through all provided data; 
  // data has been scaled such that symbols should be at -3, -1, +1, or +3 
  for (int i = 0; i < noutput_items; i++)
  {
    // unlike RD-LAP we are gray coded
    if (in[i] < -2) sym = 3;
    else if (in[i] <  0.0) sym = 2;
    else if (in[i] <  2.0) sym = 0;
    else sym = 1;

    if (reverse_polarity) sym ^= 0x02;	// yes this is correct inversion for gray coded dibits

    framer(sym);
  }


  // Tell runtime system how many input items we consumed on
  // each input stream.
  consume_each (noutput_items);

  // Tell runtime system how many output items we produced.  (Nothing, ever!)
  return 0;

}





