/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * 
 *
 */

/*
 * config.h is generated by configure.  It contains the results
 * of probing for features, options etc.  It should be the first
 * file included in your .cc file.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <fsk4_generic_f.h>
#include <gr_io_signature.h>
#include <gr_math.h>




/*
 * Create a new instance of fsk4_generic_f and return
 * a boost shared_ptr.  This is effectively the public constructor.
 */
fsk4_generic_f_sptr fsk4_make_generic_f (gr_msg_queue_sptr queue, int processing_flags)
{
  return fsk4_generic_f_sptr (new fsk4_generic_f ( queue, processing_flags));
}

/*
 * Specify constraints on number of input and output streams.
 * This info is used to construct the input and output signatures
 * (2nd & 3rd args to gr_block's constructor).  The input and
 * output signatures are used by the runtime system to
 * check that a valid number and type of inputs and outputs
 * are connected to this block.  In this case, we accept
 * only 1 input and 1 output.
 */
static const int MIN_IN = 1;	// mininum number of input streams
static const int MAX_IN = 1;	// maximum number of input streams
static const int MIN_OUT = 1;	// minimum number of output streams
static const int MAX_OUT = 1;	// maximum number of output streams

/*
 * The private constructor
 */
fsk4_generic_f::fsk4_generic_f (gr_msg_queue_sptr queue, int processing_flags)
  : gr_block ("generic_f",
	      gr_make_io_signature (MIN_IN, MAX_IN, sizeof (float)),	
//	      gr_make_io_signature (MIN_OUT, MAX_OUT, sizeof (float))),
	      gr_make_io_signature ( 0, 0, 0 )  ),
    d_queue(queue)
{

  sym_counter = 0;


  reverse_polarity = false;
  if ((processing_flags & 0x01) != 0) reverse_polarity = true;


//  set_history (NTAPS + 2);	// we need to look at the previous values covering

}

/*
 * Our virtual destructor.
 */
fsk4_generic_f::~fsk4_generic_f ()
{
  // nothing else required in this example
}




void  fsk4_generic_f::forecast(int noutput_items, gr_vector_int &inputs_required)
{
    // given output request of noutput_items return number of input items required
    int items = noutput_items; 		// this is 1:1 stub
    for (unsigned int i = 0; i < inputs_required.size(); i++)  inputs_required[i] = items;   
}






// -------------------------------------------------------------------------------
// take our stream of incoming floats, convert to symbols and pass upwards
//
// Probably will never happen:  implement soft decision decoding
//
int  
fsk4_generic_f::general_work (int noutput_items,
			       gr_vector_int &ninput_items,
			       gr_vector_const_void_star &input_items,
			       gr_vector_void_star &output_items)
{
  unsigned char sym;


  float *in = (float *) input_items[0];
 
  float *out = (float *) output_items[0];


  // run through all provided data; 
  // data has been scaled such that symbols should be at -3, -1, +1, or +3 
  for (int i = 0; i < noutput_items; i++)
  {
    if (in[i] < -2) sym = 0;
    else if (in[i] <  0.0) sym = 1;
    else if (in[i] <  2.0) sym = 2;
    else sym = 3;

    if (reverse_polarity) sym ^= 0x03;

    printf("%c",0x41+sym);

    sym_counter++;
    if (sym_counter >= 80)
    {
      sym_counter = 0;
      printf("\n");
    }


  }


  // Tell runtime system how many input items we consumed on
  // each input stream.
  consume_each (noutput_items);

  // Tell runtime system how many output items we produced.  (Nothing, ever!)
  return 0;

}





