//
//	VID.C
//		Video routines.
//

#include "morse.h"

//
//	Display a character in the "idle" display across the screen bottom.
//
void idlePutC(char c)
{
	// scroll the tone line (bottom) left
	// add a character at the end of the line
	asm {
										// Save registers
		push ax
		push bx
		push cx
		push ds
		push es
		push di
		push si
										// source and destination segments
		mov ax, VIDSEG
		push ax
		push ax
		pop ds
		pop es
										// Dest & source offsets
		mov di, 0x0E60
		mov si, 0x0E62
										// Set the move count (words)
		mov cx, 0x004F
										// Move the junk
		rep movsw
										// Restore registers
		pop si
		pop di
		pop es
		pop ds
		pop cx
		pop bx
		pop ax
	}
	pokeb(VIDSEG, (160*24)-2, c);
}

//
//	Display a character in the "tone" display across the screen bottom.
//
void tonePutC(char c)
{
	// scroll the tone line (bottom) left
	// add a character at the end of the line
	asm {
										// Save registers
		push ax
		push bx
		push cx
		push ds
		push es
		push di
		push si
										// source and destination segments
		mov ax, VIDSEG
		push ax
		push ax
		pop ds
		pop es
										// Dest & source offsets
		mov di, 0x0F00
		mov si, 0x0F02
										// Set the move count (words)
		mov cx, 0x004F
										// Move the junk
		rep movsw
										// Restore registers
		pop si
		pop di
		pop es
		pop ds
		pop cx
		pop bx
		pop ax
	}
	pokeb(VIDSEG, (160*25)-2, c);
}

//
//	Display a character in the "text" window.
//

void textPutC(char c)
{
	static int x=BOXLEF+1;

	pokeb(VIDSEG,(x<<1)+((BOXDIV-1)*160), c);

	if ((++x)>=BOXRIG)
	{
			asm {
				push ax					// save the registers we're using
				push bx
				push cx
				push dx
				push ds
				push es
				push di
				push si
										// line to scroll into
				mov bx, BOXTOP+1
										// source and destination segments
				mov ax, VIDSEG
				push ax
				push ax
				pop ds
				pop es
			}
lineloop:
			asm {
										// calculate dest line offset
				mov ax, 0x00A0
				mul bl
										// calculate the left window inside
				mov dx, BOXLEF
				inc dx
				shl dx, 1
										// combine them
				add ax, dx
				mov di, ax

				cmp bx, BOXDIV-1		// see if we're done
				je scrolldone			// leave the scroll if so

				add ax, 0xA0			// calculate offset of source
				mov si, ax

				mov cx,(BOXRIG-BOXLEF)-1
				rep movsw				// move them

				inc bx					// go to the next line
				jmp lineloop			// loop around to calculate it
			}
scrolldone:
			asm {
										// AX = word to clear; CX = count
				mov ax, 0x0720
				mov cx, (BOXRIG-BOXLEF)-1
				rep stosw				// clear the last line in the window

				pop si					// restore the registers we've saved
				pop di
				pop es
				pop ds
				pop dx
				pop cx
				pop bx
				pop ax
			}
			x=BOXLEF+1;
	}
}

//
//	Display a character in the "morse" window.
//

void morsePutC(char c)
{
	static int x=BOXLEF+1;

	pokeb(VIDSEG,(x<<1)+((BOXBOT-1)*160), c);

	if ((++x)>=BOXRIG)
	{
			asm {
				push ax					// save the registers we're using
				push bx
				push cx
				push dx
				push ds
				push es
				push di
				push si
										// line to scroll into
				mov bx, BOXDIV+1
										// source and destination segments
				mov ax, VIDSEG
				push ax
				push ax
				pop ds
				pop es
			}
lineloop:
			asm {
										// calculate dest line offset
				mov ax, 0x00A0
				mul bl
										// calculate the left window inside
				mov dx, BOXLEF
				inc dx
				shl dx, 1
										// combine them
				add ax, dx
				mov di, ax

				cmp bx, BOXBOT-1		// see if we're done
				je scrolldone			// leave the scroll if so

				add ax, 0xA0			// calculate offset of source
				mov si, ax
										// word count to move
				mov cx, (BOXRIG-BOXLEF)-1
				rep movsw				// move them

				inc bx					// go to the next line
				jmp lineloop			// loop around to calculate it
			}
scrolldone:
			asm {
										// AX = clear word; CX = word count
				mov ax, 0x0720
				mov cx, (BOXRIG-BOXLEF)-1
				rep stosw

				pop si					// restore the registers we've saved
				pop di
				pop es
				pop ds
				pop dx
				pop cx
				pop bx
				pop ax
			}
			x=(BOXLEF+1);
	}
}

//
//	end of VID.C
//
