/* Functions: 			     				*/
/* ----------                        				*/
/* checkok         -- Checks modem for 'OK' 			*/
/* checkpoints     -- Checks for conflicting options            */
/* check_for_error -- makes sure all bytes were written		*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "colors.h"

#define ERROR -1

extern int conf; /* Do we read phone numbers from a config file?          */
extern int rand; /* Do we use random (as opposed to sequential) scanning? */
extern int useStdin; /* Do we read numbers from standard input?           */

void checkoptions()
{
  if (useStdin == 1 && (rand == 1 || conf == 1)) {
     printf("You can't specify to either %srandomly%s select numbers, "
            "read numbers\nfrom a %sconfig file%s, or to read numbers "
            "from %sstandard input%s all at\nthe sametime.\n\n",
            BOLDRED, NORMAL, BOLDCYAN, NORMAL, BOLDGREEN, NORMAL);

     exit(ERROR);
  }

  if (rand == 1 && conf == 1) {
     printf("You can't specify to either %srandomly%s select numbers, "
            "read numbers\nfrom a %sconfig file%s, or to read numbers "
            "from %sstandard input%s all at\nthe sametime.\n\n",
            BOLDRED, NORMAL, BOLDCYAN, NORMAL, BOLDGREEN, NORMAL);

     exit(ERROR);
  }
}

void check_for_error(char *LogFile, int fd, int num, char *s)
{
  FILE *logfile;

  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     hangup(), close(fd), exit(ERROR);
  }

  if (num == ERROR) {
     fprintf(stderr, "%sError%s while trying to %s%s%s to/from the modem.\n", 
      	     BOLDRED, NORMAL, BOLDCYAN, s, NORMAL);
     fprintf(logfile, "Error while trying to %s to/from the modem.\n", s);
     fflush(logfile);

     hangup(), close(fd), exit(ERROR);
  }
  
  fclose(logfile);
}  

int checkok(char *LogFile, int fd, char *buf, char *s)
{
  FILE *logfile;

  if ((logfile = fopen(LogFile, "a")) == NULL) {
     perror("fopen");
     hangup(), close(fd), exit(ERROR);
  }

  if ((strstr(buf, "OK")) == NULL) {
     #if BEEP == WANTBEEP
     putchar('\a');
     #endif

     fprintf(logfile, "The modem didn't give me an \"OK\" when %s. Aborting.\n", s);
     fprintf(stderr, "The modem didn't give me an \"%sOK%s\" when %s%s%s. %sAborting%s.\n", 
	     BOLDCYAN, NORMAL, PINK, s, NORMAL, BOLDRED, NORMAL);
     fflush(logfile);
	
     return 1;
  }

  return 0;
}
