/* Simple program which will allow users to login to a gateway, and based on configuration file
 * then rlogin to machines behind the firewall
 *
 * Written By Brett Lomas
 * Copyright 1999
 *
 * Version 1.0.0
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <wait.h>
#include <errno.h>

#include "io.h"

#define checkMem(x) if( !x ) { perror( "Error allocating memory" ); exit( 1 ); }

#define DOMAIN "brett.co.nz"
#define RLOGIN_PATH "/usr/bin/rlogin"
#define ALLOWED_HOSTS_FILE "/etc/allowed_hosts"


static char **
parseHosts( char *line ) {

  char **hosts = ( char ** )calloc( 11, sizeof( char ) );

  if( !hosts )
    return NULL;
  
  int num_hosts = 0;
  
  char *ptr = strchr( line, ' ' ) + 1;
  char *end = strchr( ptr, ' ' );

  while( end != NULL && num_hosts < 10 ) {

    int size = end - ptr + 1;
    hosts[ num_hosts ] = ( char * )malloc( size );

    checkMem( hosts[ num_hosts ] );

    memset( hosts[ num_hosts ], '\0', size );

    strncpy( hosts[ num_hosts ], ptr, size - 1 );
    ptr = end + 1;
    end = strchr( ptr, ' ' );
    num_hosts++;
  }

  if( num_hosts < 10 ) {
    hosts[ num_hosts ] = ( char * )malloc( strlen( ptr ) + 1 );
    checkMem( hosts[ num_hosts ] );
    strcpy( hosts[ num_hosts ], ptr );
  }
  else
    num_hosts--; /*This allows for num_hosts begin 10, and the + 1 below... so take it back one*/

  hosts[ num_hosts + 1 ] = NULL; //terminate

  return hosts;
}

static char **
getAllowedHosts( char *logname ) {

  if( !setFileIOpath( ALLOWED_HOSTS_FILE, "#", 0 ) ) {
    fprintf( stderr, "There was an error reading the allowed hosts file: %s\n", strerror( errno ) );
    return NULL;
  }

  char logname1[ strlen( logname ) + 2 ];

  strcpy( logname1, logname );
  strcat( logname1, ":" );

  char *line;
  int found = 0;

  while( !found && ( line = readline() ) != NULL)
    if( strstr( line, logname1 ) == line )
      found = 1;
    else
      free( line );
  
  resetFileIO();

  if( found )
    return parseHosts( line );

  return NULL;
}

char *
getLocalShell( char *line ) {

  char *temp= ( char * )malloc( strlen( line ) );

  checkMem( temp );

  strncpy( temp, line + 6, strlen( line ) - 7 );

  return temp;
}

int
main( int argc, char **argv ) {

  char *logname = getenv( "LOGNAME" );
  char **allowed_hosts = getAllowedHosts( logname );

  printf( "Welcome %s to the %s login server\n\n", logname, DOMAIN );


  char hosts_message[ 2048 ];
  hosts_message[ 0 ] = '\0';

  if( !allowed_hosts || !allowed_hosts[ 0 ] ) {
    printf( "\nYou have no allowed hosts that you can connect to.\nPlease see the System Administrator.\n\n" );
    exit( 0 );
  }

  int sel;

  if( allowed_hosts[ 1 ] ) { /*ie more than one choice*/
    int max_selection = 0;
    
    for( max_selection = 0 ; allowed_hosts[ max_selection ] ; max_selection++ ) {
      
      char temp[ 50 ];
      sprintf( temp, "   %d: %s\n", max_selection + 1, allowed_hosts[ max_selection ] );
      strcat( hosts_message, temp );
      
    }
    
    printf( "Your choices are:\n\n"
	    "%s"
	    "\n", hosts_message );
    
    char selection[ 3 ];  
    selection[ 2 ] = '\0';
    
    do {
      printf( "\nPlease enter your selection: " );
      
      fread( selection, 2, 1, stdin );
      fflush(stdin);
      sscanf( selection, "%d", &sel );
    }
    while( sel <= 0 || sel > max_selection );
  }
  else {
    sel = 1;
  }

  int localmachine = 0;

  if( ( localmachine = strstr( allowed_hosts[ sel - 1 ], "local" ) == allowed_hosts[ sel -1 ] ) )
    printf( "\nDropping you to a local shell...\n" );
  else
    printf( "\nPlease wait... connecting you to the host \"%s\"\n", allowed_hosts[ sel - 1 ] );

  switch( fork() ) {
    
  case 0:
    if( !localmachine ) {
      if( execl( RLOGIN_PATH, "rlogin", allowed_hosts[ sel - 1 ], NULL ) == -1 ) {
	fprintf( stderr, "There was an error logging you into %s: %s\n", allowed_hosts[ sel - 1 ], strerror( errno ) );
	exit( 1 ); 
      }
    }
    else {

      char *shell = getLocalShell( allowed_hosts[ sel - 1 ] );

      setenv( "SHELL", shell, 1 );
      if( execl( shell, shell, NULL ) == -1 ) {
	perror( "There was an error execing you shell" );
	exit( 1 );
      }  
    }
    
  default:
    break;
  }
  
  wait( NULL ); //wait for the child
  
  printf( "\n\nThank you for coming.... bye bye now....\n\n");
  
  exit( 0 );
}
