%{
/*
 *  ipfm.l - functions parsing the configuration file
 *  
 *  Robert Cheramy <tibob@via.ecp.fr>, 1999
 *
 *  Thanks to Etienne BERNARD <eb@via.ecp.fr> for his
 *  * little manual for Lex and Yacc
 *    http://www.via.ecp.fr/~eb/textes/minimanlexyacc-english.html
 *  * sample code in ippl (http://www.via.ecp.fr/~hugo/ippl)
 *  which helped me to understand Lex and Yacc
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <db.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <string.h>

#include "utils.h"
#include "filter.h"
#include "y.tab.h"
#include "data.h"

int line;
void parseerror(char *s, int line);
%}

white     [ \t]+

integer   [0-9]+

ippart    [0-9]{1,3}

ip        ({ippart}"."){3}{ippart}

%%

{white}               { /* Ignore */ }
"#".*$                { /* Ignore */ }
"\n"                  { line++;  return EOL; }
"/"                     return SLASH;

[Ll][Oo][Gg]                     return LOG;
[Nn][Ee][Ww][Ll][Oo][Gg]         return NEWLOG; 
[Nn][Oo][Tt]                     return NOT;
[Nn][Oo][Nn][Ee]                 return NONE;
[Bb][Oo][Tt][Hh]                 return BOTH;
[Ff][Rr][Oo][Mm]                 return FROM;
[Tt][Oo]                         return TO;
[Tt][Ii][Mm][Ee]                 return TIME;
[Dd][Ee][Vv][Ii][Cc][Ee]         return DEVICE;
[Ww][Ii][Tt][Hh]                 return WITH;
[Ss][Oo][Rr][Tt]                 return SORT;

[Rr][Ee][Ss][Oo][Ll][Vv][Ee]    {yylval.longval = 1; return DNS; }
[Nn][Oo][Rr][Ee][Ss][Oo][Ll][Vv][Ee] {yylval.longval = 0; return DNS; }
[Ii][Nn]              { yylval.SortFunc = DataCompareIn; return SORTFUNC; }
[Oo][Uu][Tt]          { yylval.SortFunc = DataCompareOut; return SORTFUNC; }
[Tt][Oo][Tt][Aa][Ll]  { yylval.SortFunc = DataCompareTotal; return SORTFUNC; }

[Ff][Ii][Ll][Ee][Nn][Aa][Mm][Ee] {
                        char c;
			int trash = FALSE;
			char *s_filename = NULL;
			int count = 1;

			while ((c = input()) == ' ' || c == '\t');

			s_filename = strdup("");
			unput(c);

                        while ((c = input()) != '\n') {
			  /* note that a filename can contain ' ',
			     as any caracter that is not '\n' */
			  if (!trash) {
			    /* incerase size of string */
			    s_filename = realloc(s_filename, ++count);
			    /* append c to the string */
			    s_filename = strncat(s_filename, &c, 1);
			  }
			}
			if (strlen(s_filename) == 0) {
			  parseerror("Unexpected file name. Skipping line", line);
			} else {
			  yylval.stringval = s_filename;
			  return FILENAME;
			}
                      }

{ip}                  {
                        yylval.stringval = strdup(yytext);
                        return IP;
                      }

{integer}             {
                        yylval.longval = atol(yytext);
			return NUMBER;
                      }

"day"                 { yylval.longval = 24*60*60; return DATETYPE; }
"hour"                { yylval.longval = 60*60;    return DATETYPE; }
"minute"              { yylval.longval = 60;       return DATETYPE; }
"second"              { yylval.longval = 1;        return DATETYPE; }

[0-9A-Za-z]+          {
                        yylval.stringval = strdup(yytext);
                        return STRING;
                      }


.                     { parseerror("unexpected token.", line); }
%%

int yywrap() {
  return 1;
}
