/*
 *  data.c - counts the data exchanged
 *
 *  Copyright (C) 1999 Robert Cheramy <tibob@via.ecp.fr>
 *  Copyright (C) 1999 Andres Krapf <dae@via.ecp.fr>
 *
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "utils.h"
#include "filter.h"
#include "data.h"
#include "init.h"

extern struct OptionsType Options;
extern struct AllLogsType * pAllLogs;

void data_add(struct AllLogsType * pLog, u_int32_t ip, int in, int out) {
  struct s_data *p_datatmp;

  if (pLog->Data == NULL || pLog->Data->ip > ip) {
    //    p_datatmp = p_data;
    p_datatmp = malloc(sizeof(struct s_data));
    p_datatmp->prev = NULL;
    /* p_datatmp is NULL or a value, and there is no need for an if here*/
    p_datatmp->next = pLog->Data;
    p_datatmp->ip = ip;
    p_datatmp->in = in;
    p_datatmp->out = out;
    if (pLog->Data != NULL) {
      pLog->Data->prev = p_datatmp;
    }
    pLog->Data = p_datatmp;
    
  } else {
    for (p_datatmp = pLog->Data; (p_datatmp->next != NULL) && (p_datatmp->ip < ip); p_datatmp = p_datatmp->next);

    if (p_datatmp->ip == ip) {
      p_datatmp->in += in;
      p_datatmp->out += out;
      
    } else if (p_datatmp->next == NULL && p_datatmp->ip < ip) {
      p_datatmp->next = malloc(sizeof(struct s_data));
      p_datatmp->next->prev = p_datatmp;
      p_datatmp->next->next = NULL;
      p_datatmp->next->ip = ip;
      p_datatmp->next->in = in;
      p_datatmp->next->out = out;
    } else {
      /*  if (p_datatmp->next == NULL && p_datatmp->ip > ip) {
	  or p_datatmp->ip > ip && p_datatmp !=NULL) */
      p_datatmp->prev->next = malloc(sizeof(struct s_data));
      p_datatmp->prev->next->prev = p_datatmp->prev;
      p_datatmp->prev->next->next = p_datatmp;
      p_datatmp->prev->next->ip = ip;
      p_datatmp->prev->next->in = in;
      p_datatmp->prev->next->out = out;
      p_datatmp->prev = p_datatmp->prev->next;
    }
  }
}

void data_flush(struct AllLogsType * pLog) {
  pid_t pid;
  char * FileName;

  FileName = timefile(pLog->LogFile, pLog->NextTime);
  pid = fork();
  if (-1 == pid)
  {
    fprintf(stderr, "couldn't fork\n");
    free(FileName);
    return;
  }
  else if (0 == pid)
  {
    /* replace file */
    FILE *logfile;
    char DataToFile[MAX_DATA_SIZE];

    DataSort(pLog);

#if DEBUG >= 3
    printf("Printing in %s\n", FileName);
#endif
    logfile = fopen(FileName, "w");
    free(FileName);
    if (logfile == NULL) {
      printf("Error opening log file. Exiting.\n");
      exit(1);
    }
    fprintf(logfile, "%-35s%15s%15s%15s\n",
	    "HOST",
	    "IN",
	    "OUT",
	    "TOTAL");
    while (pLog->Data != NULL) {
      DataFormat(pLog, pLog->Data, DataToFile, MAX_DATA_SIZE);
      fprintf(logfile, "%s", DataToFile);
      /* Do not forget to free tables */
      if (pLog->Data->next != NULL) {
	pLog->Data = pLog->Data->next;
	free(pLog->Data->prev);
	pLog->Data->prev = NULL;
      } else {
	pLog->Data = NULL;
      }
    }
    fprintf(logfile, "\n");
    fclose(logfile);
    exit(0);
  }
  else {
    while (pLog->Data != NULL)
    {
      if (pLog->Data->next != NULL) {
	pLog->Data = pLog->Data->next;
	free(pLog->Data->prev);
	pLog->Data->prev = NULL;
      } else {
	pLog->Data = NULL;
      }
    }
    free(FileName);
  }
}

void DataSort(struct AllLogsType * pLog)
{
  if (pLog->Sort)
  {
    int Number,j;
    struct s_data * pTempData;
    struct s_data ** pDataArray;

    /* 
     * on devrais mettre un pur compteur histoire de 
     * pas avoir a recompter a chaque fois
     */

    Number = 0;
    for (pTempData = pLog->Data; NULL != pTempData; pTempData = pTempData->next)
      Number++;

    pDataArray = (struct s_data **) malloc (Number * sizeof(struct s_data *));

    j = 0;
    for (pTempData = pLog->Data; NULL != pTempData; pTempData = pTempData->next)
      pDataArray[j++] = pTempData;

    if (pDataArray)
    {
      qsort(pDataArray, Number, sizeof(struct s_data *), pLog->SortFunc);

      for (j = 1; j < Number-1; j++)
      {
	pDataArray[j]->next = pDataArray[j+1];
	pDataArray[j]->prev = pDataArray[j-1];
      }

      if (1 < Number)
      {
	pDataArray[0]->next = pDataArray[1];
	pDataArray[Number-1]->prev = pDataArray[Number-2];
      }
      pDataArray[0]->prev = NULL;
      pDataArray[Number-1]->next = NULL;

      pLog->Data = pDataArray[0];
      free(pDataArray);
    }
  }
}

int DataCompareOut(const void * ptr1, const void * ptr2)
{
  if ((**(struct s_data **)ptr1).out > (**(struct s_data **)ptr2).out)
    return(-1);

  else if ((**(struct s_data **)ptr1).out < (**(struct s_data **)ptr2).out)
    return(1);

  else
    return(0);
}

int DataCompareIn(const void * ptr1, const void * ptr2)
{
  if ((**(struct s_data **)ptr1).in > (**(struct s_data **)ptr2).in)
    return(-1);

  else if ((**(struct s_data **)ptr1).in < (**(struct s_data **)ptr2).in)
    return(1);

  else
    return(0);
}

int DataCompareTotal(const void * ptr1, const void * ptr2)
{
  if ((**(struct s_data **)ptr1).out + (**(struct s_data **)ptr1).in >
      (**(struct s_data **)ptr2).out + (**(struct s_data **)ptr2).in)
    return(-1);

  else if ((**(struct s_data **)ptr1).out + (**(struct s_data **)ptr1).in <
	   (**(struct s_data **)ptr2).out + (**(struct s_data **)ptr2).in)
    return(1);

  else
    return(0);
}

void DataFormat(struct AllLogsType * pLog, struct s_data * pData, char * pFormatedData, int BufLen)
{
  struct in_addr addr;
  char NotLookedUp = 0;

  memset(pFormatedData, 0, BufLen);
  memcpy(&addr, &pData->ip, sizeof(struct in_addr));

  if (pLog->ReverseLookup)
  {
    struct hostent * he;
    he = gethostbyaddr((char *) &addr, sizeof (struct in_addr), AF_INET);
    if ((he != NULL) && (strlen(he->h_name) <= 34) && (strlen(he->h_name) > 0))
    snprintf(pFormatedData, BufLen, "%-35s%15lu%15lu%15lu\n",
	     he->h_name,
	     pData->in, 
	     pData->out, 
	     pData->in + pData->out);
    else
      NotLookedUp = 1;
  }
  if (!pLog->ReverseLookup || NotLookedUp)
  {
    char * res;
    res = inet_ntoa(addr);
    snprintf(pFormatedData, BufLen, "%-35s%15lu%15lu%15lu\n",
	     res,
	     pData->in, 
	     pData->out, 
	     pData->in + pData->out);
  }
}
