/*********************************************************************
 * IP Flow Meter                                                     *
 * http://www.via.ecp.fr/~tibob/ipfm                                 *
 * ipfm@via.ecp.fr                                                   *
 *********************************************************************
 * Copyright (C) 1999 Robert Cheramy <tibob@via.ecp.fr>              *
 * Copyright (C) 1999 Andres Krapf <dae@via.ecp.fr>                  *
 *                                                                   *
 *********************************************************************
 * This program uses the libpap for best portability.                *
 * libpcap can be found at ftp://ftp.ee.lbl.gov/libpcap.tar.Z        *
 *********************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <pcap.h>
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <string.h>

#include "utils.h"
#include "pcap.h"
#include "filter.h"
#include "data.h"
#include "init.h"

struct passwd *runas;
char *device = NULL;
struct AllLogsType * pAllLogs = NULL;

int main(int argc, char *argv[])
{
  struct ip *p_packet;
  struct AllLogsType * pTempLog;

  ParseCmdLine(argc, argv);
  Init();

  /* Disabled because I can't close the socket as nobody.
     And I don't feel like using threads now :)
  runas = getpwnam("nobody");
  setuid(runas->pw_uid);
  */

  for(;;) {
    p_packet = (struct ip *) getnextippkt();
    
    dofilter(p_packet);

    /* Well that's an aproximation. I should perhaps use an alarm() */
    for (pTempLog = pAllLogs; NULL != pTempLog; pTempLog = pTempLog->Next)
    {
      if (time(NULL) > pTempLog->NextTime) {
	data_flush(pTempLog);
	pTempLog->NextTime += pTempLog->TimeInterval;
      }
    }
  }
  closepcap();
  Exit(0);
}
