/* sweepgen.h
 * header file for the Ncurses based sweep generator
 * Jim Jackson  <jj@scs.leeds.ac.uk>  Jan 97
 */

#define VERSION "sweepgen  Ver. 1.0 (Feb 98)   Ncurses based Digital Sweep Generator"

#define DEFAULT_BUFFERS 3
#define DAC_FILE "/dev/dsp"
#define SAMPLERATE 22050
#define EFAIL -1

extern int vflg,dflg;

extern int DAC;
extern unsigned int samplerate;         /* Samples/sec        */
extern unsigned int stereo;             /* stereo mono */
extern unsigned int afmt;               /* format for DSP  */
extern int Nfragbufs;                   /* number of driver buffers */
extern int fragsize;                    /* size of driver buffer fragments */
extern int fragsamplesize;              /* size of fragments in samples */

    /* Sweeping channel.... */
extern char wf[32];                     /* waveform type */
extern unsigned int freq;               /* signal frequency */
extern int ratio;                       /* used in pulse, sweep etc */
extern int Gain;                        /* Amplification factor */

    /* Swept channel..... */
extern char wf2[32];                   /* waveform type */
extern unsigned int freqF, freqT;      /* low and upper freq of sweep */
extern unsigned int freqC;             /* centre freq and deviation of sweep */
extern int frdev;
extern int Gain2;                      /* Amplification factor */

