;****************************************************************************
;                                                                           *
; CTRL2CAP								    *
;								  	    *
; Copyright (c) 1995,1996 Mark Russinovich                                  *
;                                                                           *
; You can modify and use this code in whatever manner you wish as long as   *
; its not for commercial purposes.                                          *
;									    *
;****************************************************************************
;									    *
; CTRL2CAP: Switches the caps and control key universally (no exceptions)   *
;                                                                           *
;****************************************************************************

;===========================================================================
	page	,132
	title	ctrl2cap - ctrl2cap VxD
	name	ctrl2cap.vxd
;===========================================================================
;
;   Module:
;	Contains everything
;
;===========================================================================
;
;   Functional Description: - switches ctrl and caps universally (we don't
;			      want the DOS ctrl2cap because it will defeat
;			      the purpose). Also, if the system.ini has
;			      a [ctrl2cap] section with a key "escape=true",
;			      then the escape key will be swapped with the
;			      accent grave key as well.
;			
;============================================================================

;============================================================================
;				I N C L U D E S
;============================================================================
.386p
	.xlist
	include	vmm.inc
	include vwin32.inc
	include vkd.inc
	include vmd.inc
	include debug.inc
	include ctrl2cap.inc
.list

;============================================================================
;                              D E F I N E S
;============================================================================

; scancode definitions
SCANESCAPE	equ	0E0h
CAPSLOCK	equ	3Ah
LEFTCTRL	equ	1Dh
ACCENTGRAVE	equ	29h
ESCAPEKEY	equ	01h
LEFTSHIFT	equ	2Ah
RIGHTSHIFT	equ	36h
PRINTSCREEN	equ	2Ah
PRINTSCREEN1	equ	37h

; up/down bit value
UP		equ	0
DOWN		equ	1

;============================================================================
; 			  P U B L I C   D A T A
;============================================================================

VXD_LOCKED_DATA_SEG

; Previous routine on keyboard hook
Keyboard_Proc		dd	0

; what should the print-key be mapped to? (0 means no swap)
SwtchPrnKey		dd	0

; should escape and accent grave be switched?
SwtchEscapeAccent	dd	0

; what is the shift state?
LeftShiftState		dd	0
RightShiftState		dd	0

; what is the printscreen state?
PrintScreenState	dd	0

; section in system.ini
SectionName		db	"ctrl2cap", 0

; key names in system.ini
EscKeyName		db	"escape", 0
PrnKeyName		db	"printscreen", 0

; precode data for force-key
ForcePreByte		db	0E0h, 0

; have we gotten a precode, yet?
PreCode			db 	0

VXD_LOCKED_DATA_ENDS


;============================================================================
;	           D E V I C E   D E C L A R A T I O N
;============================================================================

VXD_LOCKED_CODE_SEG

; registration block

DECLARE_VIRTUAL_DEVICE CTRL2CAP,	\
	CTRL2CAP_MAJOR_VERSION, 	\
	CTRL2CAP_MINOR_VERSION,	        \
	Ctrl2cap_Control,,	        \
	UNDEFINED_INIT_ORDER

;============================================================================
;			    M A I N   C O D E
;============================================================================

;============================================================================
;
; Ctrl2cap_Control - Device control procedure for the VxD. Dispatches all
;                  Windows VxD messages.
;
; Exit:	If carry clear then
;	    Successful
;	else
;	    Control call failed
;
; Destroys: EAX, EBX, ECX, EDX, ESI, EDI, Flags
;
;============================================================================

public Ctrl2cap_Control
Ctrl2cap_Control PROC NEAR

	Control_Dispatch INIT_COMPLETE, Ctrl2cap_Device_Init
	clc
	ret

Ctrl2cap_Control ENDP

VXD_LOCKED_CODE_ENDS

;==============================================================================
;		 	 P A G E A B L E   C O D E
;==============================================================================

VXD_PAGEABLE_CODE_SEG

;============================================================================
;
; Ctrl2cap - keyboard hook switches the control and caps when it sees those
; 	     keys come through. We've got to switch both the up key and the
;	     down key. If the system.ini parameter is set, this routine also
;	     switches accent grave and escape.
;
; Entry: CL - Scancode of key pressed.
;
;============================================================================

BeginProc Ctrl2cap, Hook_Proc Keyboard_Proc

	; get the scancode

        mov     dl, cl
        and     dl, 7Fh

;	Trace_Out "Key: #CL"

	;----------------------------------------------------------------------
	; 
	; PRINTSCREEN HANDLER
	;
	;----------------------------------------------------------------------
	; first, see if we even care
	
	cmp	SwtchPrnKey, 0
	jz	checklshift

	; have we received the pre-scan code (0xE0)?

	cmp	PreCode, 0
	jz	checkprecode
	mov	PreCode, 0

	; is this key a printscreen?

	cmp	dl, PRINTSCREEN
	jnz	checkprintkey1

	; got a printscreen, so swap it
	
	and	cl, 80h
	or	cl, byte ptr SwtchPrnKey
	test	cl, 80h
	jz	printscreendown
	mov	PrintScreenState, UP
	jmp	chain

printscreendown:
	mov	PrintScreenState, DOWN
	jmp	chain

	; we didn't get a printscreen, but see if this is the secondary
	; scancode generated by printscreen, which we must swallow if we
	; are swapping

checkprintkey1:

	; if printscreen is down, we have to squash secondary print-screen
	
	cmp	PrintScreenState, DOWN
	jnz	forceprecode

	; is it the secondary printscreen key?
	
	cmp	dl, PRINTSCREEN1
	jnz	forceprecode

	; yep, swallow it

	stc
	ret

	; okay, its another two-byte scancode that we should send in

forceprecode:
	push	ecx
	push	esi
	mov	ecx, 1
	lea	esi, ForcePreByte
	VxDCall	VKD_Force_Keys
	pop	esi
	pop	ecx
	jmp	chain
	
	; see if this is the precode byte

checkprecode:
	cmp	cl, SCANESCAPE	
	jnz	checklshift
	mov	PreCode, 1
	stc				; swallow it so system ignores it until
	ret				; we figure out what to do with it

	;----------------------------------------------------------------------
	;
	; CODE TO KEEP TRACK OF SHIFT KEY STATE
	;
	;----------------------------------------------------------------------
	; is the left-shift status changing?

checklshift:	
	cmp	dl, LEFTSHIFT
	jnz	checkrshift
	test	cl, 80h
	jz	leftshiftdown
	mov	LeftShiftState, UP
	jmp	chain

leftshiftdown:
	mov	LeftShiftState, DOWN
	jmp	chain
	
	; is the right-shift status changing?

checkrshift:
	cmp	dl, RIGHTSHIFT
	jnz	cap2ctrl
	test	cl, 80h	
	jz	rightshiftdown
	mov	RightShiftState, UP
	jmp	chain

rightshiftdown:
	mov	RightShiftState, DOWN
	jmp	chain

	;----------------------------------------------------------------------
	;
	; CAP2CTRL CODE
	;
	;----------------------------------------------------------------------
	; switch caps-lock to control

cap2ctrl:
	cmp	dl, CAPSLOCK
	jnz	esc2accent
	and	cl, 80h
	or	cl, LEFTCTRL
	jmp	chain

	;----------------------------------------------------------------------
	;
	; ESCAPE 2 ACCENT GRAVE CODE
	;
	;----------------------------------------------------------------------
	; is the escape-accent grave switch option turned on?

esc2accent:
	cmp	SwtchEscapeAccent, 0
	jz	chain

	; yes, see if the escape key has been pressed

escape:
	cmp	dl, ESCAPEKEY
	jnz	accent
	cmp	LeftShiftState, UP	; is shift key down?
	jnz	chain			; yep, don't switch tilde
	cmp	RightShiftState, UP
	jnz	chain
	and	cl, 80h
	or	cl, ACCENTGRAVE
	jmp	chain

	; see if the accent key has been pressed (needs shift up)

accent:
	cmp	dl, ACCENTGRAVE
	jnz	chain
	cmp	LeftShiftState, UP	; is a shift key down?
	jnz	chain			; yep, they want tilde - no switch
	cmp	RightShiftState, UP	
	jnz	chain
	and	cl, 80h
	or	cl, ESCAPEKEY
	jmp	chain

	;----------------------------------------------------------------------
	;
	; FALL THROUGH TO PREVIOUS HANDLER
	;
	;----------------------------------------------------------------------
	; call the previous hooker
chain:
;	Trace_Out "---> #CL"
	call	Keyboard_Proc
	clc				; let the key through
	ret

EndProc Ctrl2cap

VXD_PAGEABLE_CODE_ENDS

;============================================================================
;	   D E V I C E   I N I T I A L I Z A T I O N   C O D E
;============================================================================

VXD_ICODE_SEG

;============================================================================
;									
; Ctrl2cap_Device_Init
;									
;									
; Entry: ebx -> System VM handle (not used)
;        edx -> Reference data from real mode init portion
;
; Exit: If successful then
;           Carry flag is clear
;       else
;           Carry flag is set to indicate an error -- Device not initialized
;
;============================================================================

BeginProc Ctrl2cap_Device_Init

	; see if the user wants escape-accent grave switched

	xor	eax, eax			; default == no switch
	mov	esi, offset32 SectionName
	mov	edi, offset32 EscKeyName
	VMMCall	Get_Profile_Boolean
	mov	SwtchEscapeAccent, eax

	; see if the user wants print-key swapped
	xor	eax, eax
	mov	esi, offset32 SectionName
	mov	edi, offset32 PrnKeyName
	VMMCall	Get_Profile_Hex_Int
	mov	SwtchPrnKey, eax

	; hook the keyboard

	GetVxDServiceOrdinal eax, VKD_Filter_Keyboard_Input
	mov	esi, offset32 Ctrl2cap
	VMMCall	Hook_Device_Service
	mov	Keyboard_Proc, esi
	clc
	ret

EndProc Ctrl2cap_Device_Init

VXD_ICODE_ENDS

end
