//
// Reghide.h
//
// Various native API stuff that we need
//

#define OBJ_CASE_INSENSITIVE 0x40

typedef DWORD ULONG;
typedef WORD  USHORT;
typedef LONG NTSTATUS;

#define NT_SUCCESS(Status) ((NTSTATUS)(Status) >= 0)

typedef struct _UNICODE_STRING {
    USHORT Length;
    USHORT MaximumLength;
    PWSTR  Buffer;
} UNICODE_STRING;
typedef UNICODE_STRING *PUNICODE_STRING;


typedef struct _OBJECT_ATTRIBUTES {
    ULONG Length;
    HANDLE RootDirectory;
    PUNICODE_STRING ObjectName;
    ULONG Attributes;
    PVOID SecurityDescriptor;        // Points to type SECURITY_DESCRIPTOR
    PVOID SecurityQualityOfService;  // Points to type SECURITY_QUALITY_OF_SERVICE
} OBJECT_ATTRIBUTES;
typedef OBJECT_ATTRIBUTES *POBJECT_ATTRIBUTES;

#define InitializeObjectAttributes( p, n, a, r, s ) { \
    (p)->Length = sizeof( OBJECT_ATTRIBUTES );          \
    (p)->RootDirectory = r;                             \
    (p)->Attributes = a;                                \
    (p)->ObjectName = n;                                \
    (p)->SecurityDescriptor = s;                        \
    (p)->SecurityQualityOfService = NULL;               \
    }

NTSTATUS (__stdcall *NtCreateKey)(
		HANDLE KeyHandle, 
		ULONG DesiredAccess, 
		POBJECT_ATTRIBUTES ObjectAttributes,
		ULONG TitleIndex, 
		PUNICODE_STRING Class, 
		ULONG CreateOptions, 
		PULONG Disposition 
		);

NTSTATUS (__stdcall *NtSetValueKey)(
		IN HANDLE  KeyHandle,
		IN PUNICODE_STRING  ValueName,
		IN ULONG  TitleIndex,			/* optional */
		IN ULONG  Type,
		IN PVOID  Data,
		IN ULONG  DataSize
		);


NTSTATUS (__stdcall *NtDeleteKey)(
		HANDLE KeyHandle
		);
