

	format PE GUI 4.0 on 'null.stub'
	entry _start
	stack 20000h

	include '%fasminc%/win32a.inc'
	include 'fasm32.mac'
	include 'gemoroy.inc'
	include 'chatlist.ash'

;
; #########################################################################
;
	macro TBbutton bID,cID
	     {
	       mov     [s_tbbutton.iBitmap],bID
	       mov     [s_tbbutton.fsStyle],TBSTYLE_BUTTON
	       mov     [s_tbbutton.idCommand],cID
	       @call   [SendMessage],[h_toolbar],TB_ADDBUTTONS,1,s_tbbutton
	     }

	macro TBblank
	     {
	       mov     [s_tbbutton.iBitmap],ebx
	       mov     [s_tbbutton.fsStyle],TBSTYLE_SEP
	       mov     [s_tbbutton.idCommand],ebx
	       @call   [SendMessage],[h_toolbar],TB_ADDBUTTONS,1,s_tbbutton
	     }
;
; #########################################################################
;
  section '.code' code readable executable
;
; #########################################################################
;

	      include 'chatlist.inc'

 _start:
	      xor     ebx,ebx
	      @call   [GetModuleHandle],ebx
	      mov     [h_inst],eax

	      mov     [wc.hInstance],eax
	      ;mov     [wc.style],CS_GLOBALCLASS+CS_DBLCLKS
	      ;mov     [wc.lpfnWndProc],ChatListProc
	      ;mov     [wc.cbWndExtra],4
	      ;mov     [wc.hbrBackground],ebx
	      ;mov     [wc.cbClsExtra],ebx
	      ;mov     [wc.lpszMenuName],ebx
	      ;mov     [wc.lpszClassName],oedit_class
	      @call   [LoadCursor],ebx,IDC_ARROW
	      mov     [wc.hCursor],eax
	      ;@call   [RegisterClass],wc
	      ;or      eax,eax
	      ;jz      .end_loop

	      mov     [wc.style],CS_HREDRAW+CS_VREDRAW
	      mov     [wc.lpfnWndProc],MainWndProc
	      mov     [wc.cbClsExtra],ebx
	      mov     [wc.cbWndExtra],ebx
	      mov     [wc.hbrBackground],COLOR_BTNFACE+1
	      mov     [wc.lpszMenuName],ID_MENU
	      mov     [wc.lpszClassName],c_w_name
	      mov     eax,[h_inst]
	      @call   [LoadIcon],eax,ID_ICON
	      mov     [wc.hIcon],eax
	      @call   [RegisterClass],wc
	      @call   [CreateWindowEx],ebx,eax,c_w_name,WS_OVERLAPPEDWINDOW,ebx,ebx,400,350,ebx,ebx,[h_inst],ebx
	      mov     [h_wnd],eax
	      push    eax SW_SHOW eax
	      call    [ShowWindow]
	      call    [UpdateWindow]

	      @call   [LoadAccelerators],[h_inst],ID_ACCEL
	      mov     [h_accel],eax

	      mov     esi,[h_wnd]
	      mov     edi,msg
 .msg_loop:
	      @call   [GetMessage],edi,ebx,ebx,ebx
	      or      eax,eax
	      jz      .end_loop
	      @call   [TranslateAccelerator],esi,[h_accel],edi
	      or      eax,eax
	      jnz     .msg_loop
	      push    edi edi
	      call    [TranslateMessage]
	      call    [DispatchMessage]
	      jmp     .msg_loop
 .end_loop:
	      @call   [ExitProcess],[msg.wParam]
	      call    [InitCommonControls]
;
;
 MainWndProc:
	      @enter
	      @push   ebx,esi,edi
	      xor     ebx,ebx
	      mov     eax,dword [umsg]

	      cmp     eax,WM_CREATE
	      je      @wmcreate
	      cmp     eax,WM_COMMAND
	      je      @wmcommand
	      cmp     eax,WM_SIZE
	      je      @wmsize
	      cmp     eax,WM_INITMENU
	      je      @wminitmenu
	      cmp     eax,WM_ACTIVATE
	      je      @wmactivate
	      cmp     eax,WM_SETFOCUS
	      je      @wmactivate
	      cmp     eax,WM_CLOSE
	      je      @wmclose
	      cmp     eax,WM_DESTROY
	      je      @wmdestroy

	      @call   [DefWindowProc],dword [hwnd],dword [umsg],dword [wparam],dword [lparam]
	      jmp     @finish

   @wmcreate:
	      mov     [ofn.lStructSize],sizeof.OPENFILENAME
	      mov     eax,[h_inst]
	      mov     [ofn.hInstance],eax
	      mov     eax,[hwnd]
	      mov     [ofn.hwndOwner],eax
	      mov     [ofn.lpstrFilter],filter
	      mov     [ofn.lpstrFile],log_path
	      mov     [ofn.nMaxFile],MAX_PATH
	      mov     [ofn.nMaxFileTitle],ebx
	      mov     [ofn.lpstrInitialDir],ebx
	      mov     [ofn.lpstrDefExt],def_ext
	      mov     [ofn.Flags],OFN_EXPLORER+OFN_OVERWRITEPROMPT

	      @call   [wsprintf],str_buffer,format_title,c_w_name,offline_msg
	      add     esp,4*4
	      @call   [SetWindowText],dword [hwnd],str_buffer

	      @call   [GetSysColor],COLOR_WINDOWTEXT
	      mov     [chatlist_colors],eax
	      @call   [GetSysColor],COLOR_WINDOW
	      mov     [chatlist_colors+4],eax
	      @call   [GetSysColor],COLOR_HIGHLIGHTTEXT
	      mov     [chatlist_colors+8],eax
	      @call   [GetSysColor],COLOR_HIGHLIGHT
	      mov     [chatlist_colors+12],eax

	      mov     dword [nick_name],'User'
	      mov     [nick_name+4],0

	      mov     dword [log_path],'logo'
	      mov     dword [log_path+4],'.log'
	      mov     [log_path+8],0

	      @call   [GetModuleFileName],ebx,ini_path,MAX_PATH
	      mov     dword [eax+(ini_path-4)],'.ini'
	      @call   [GetFileAttributes],ini_path
	      js      @default_setting
	      @call   [CharLower],ini_path

	      @call   get_ini_color,ini_path,sec_Colors,key_Text,chatlist_colors
	      @call   get_ini_color,ini_path,sec_Colors,key_Background,chatlist_colors+4
	      @call   get_ini_color,ini_path,sec_Colors,key_SelText,chatlist_colors+8
	      @call   get_ini_color,ini_path,sec_Colors,key_SelBackground,chatlist_colors+12


	      mov     [wp.length],sizeof.WINDOWPLACEMENT
	      @call   [GetWindowPlacement],dword [hwnd],wp
	      @call   get_ini_int,ini_path,sec_Window,key_Top,wp.rcNormalPosition.top
	      @call   get_ini_int,ini_path,sec_Window,key_Left,wp.rcNormalPosition.left
	      @call   get_ini_int,ini_path,sec_Window,key_Right,wp.rcNormalPosition.right
	      @call   get_ini_int,ini_path,sec_Window,key_Bottom,wp.rcNormalPosition.bottom
	      mov     [wp.showCmd],SW_HIDE
	      @call   [SetWindowPlacement],dword [hwnd],wp

	      @call   [GetPrivateProfileString],sec_Options,key_Nickname,nick_name,nick_name,20,ini_path
	      @call   [GetPrivateProfileString],sec_Options,key_Download,down_path,down_path,MAX_PATH,ini_path

	 @default_setting:

	      ;    (ToolBar)
	      ; --------------------------------
	      mov     [s_tbbutton.iBitmap],ebx
	      mov     [s_tbbutton.idCommand],ebx
	      mov     [s_tbbutton.fsState],TBSTATE_ENABLED
	      mov     [s_tbbutton.fsStyle],TBSTYLE_SEP
	      mov     [s_tbbutton.dwData],ebx
	      mov     [s_tbbutton.iString],ebx
	      @call   [CreateToolbarEx],dword [hwnd],WS_CHILD+WS_CLIPSIBLINGS,300,1,ebx,ebx,s_tbbutton,1,16,16,ebx,ebx,sizeof.TBBUTTON
	      mov     [h_toolbar],eax
	      @call   [ShowWindow],eax,SW_SHOW

	      @call   [LoadBitmap],[h_inst],ID_TBBITMAP
	      @call   SetBmpColor,eax
	      mov     [s_tbaddbitmap.hInst],ebx
	      mov     [s_tbaddbitmap.nID],eax
	      @call   [SendMessage],[h_toolbar],TB_ADDBITMAP,6,s_tbaddbitmap

	      TBbutton 0,IDM_CONNECT
	      TBbutton 1,IDM_DISCONNECT
	      TBblank
	      TBbutton 2,IDM_OPTIONS
	      TBbutton 3,IDM_SAVELOG
	      TBbutton 4,IDM_SENDFILE
	      TBblank
	      TBbutton 5,IDM_ABOUT

	      ;     
	      ; ---------------------------------
	      @call   [CreateWindowEx],WS_EX_CLIENTEDGE,iedit_class,ebx,iedit_style,ebx,ebx,ebx,ebx,dword [hwnd],ebx,[h_inst],ebx
	      mov     [h_iwnd],eax
	      @call   [SendMessage],eax,EM_LIMITTEXT,MAX_PATH,ebx

	      ;     
	      ; ----------------------------------
	      @call   [CreateWindowEx],WS_EX_CLIENTEDGE,oedit_class,ebx,oedit_style,ebx,ebx,ebx,ebx,dword [hwnd],ebx,[h_inst],ebx
	      mov     [h_ownd],eax

	      @call   [GetStockObject],SYSTEM_FIXED_FONT
	      @bpush  [h_ownd],WM_SETFONT,eax,ebx
	      @bpush  [h_iwnd],WM_SETFONT,eax,ebx
	      call    [SendMessage]
	      call    [SendMessage]

	      @call   [SendMessage],[h_ownd],CLM_SETTEXTCOLOR,[chatlist_colors],[chatlist_colors+4]
	      jmp     @done


   @wmcommand:
	      mov     eax,[wparam]
	      and     eax,0FFFFh
	      sub     eax,SEND_MESSAGE
	      jb      @done
	      cmp     eax,IDM_ABOUT-SEND_MESSAGE
	      ja      @done
	      jmp     dword [eax*4+label_array]

  label_array dd .send_message
	      dd .clear_iwnd
	      dd .clear_ownd
	      dd .idm_connect
	      dd .idm_disconnect
	      dd @wmclose
	      dd .idm_sendfile
	      dd .idm_savelog
	      dd .idm_options
	      dd .idm_about

	 .send_message:
	      @call   [GetWindowText],[h_iwnd],str_buffer,MAX_PATH
	      or      eax,eax
	      jz      @done
	      @call   [wsprintf],result_buffer,format_msg,nick_name,str_buffer
	      add     esp,4*4
	      @call   SendToDisplay,[h_ownd],result_buffer

	 .clear_iwnd:
	      @call   [SetWindowText],[h_iwnd],null_str
	      jmp     @done
	 .clear_ownd:
	      @call   [SetWindowText],[h_ownd],null_str
	      jmp     @done

	 .idm_connect:
	      jmp     @done
	 .idm_disconnect:
	      jmp     @done
	 .idm_sendfile:
	      jmp     @done

	 .idm_savelog:
	      @call   [GetSaveFileName],ofn
	      or      eax,eax
	      jz      @done

	      @call   [CreateFile],log_path,GENERIC_WRITE,FILE_SHARE_READ,ebx,CREATE_ALWAYS,ebx,ebx
	      inc     eax
	      jz      @done
	      dec     eax
	      mov     [h_file],eax
	      @call   [SendMessage],[h_ownd],WM_GETTEXTLENGTH,ebx,ebx
	      inc     eax
	      mov     [tmp_var_buffer],eax
	      @call   [VirtualAlloc],ebx,eax,MEM_COMMIT,PAGE_READWRITE
	      or      eax,eax
	      jz      @F
	      mov     [p_mem],eax
	      @call   [SendMessage],[h_ownd],WM_GETTEXT,[tmp_var_buffer],eax
	      @call   [WriteFile],[h_file],[p_mem],eax,tmp_var_buffer,ebx
	      @call   [VirtualFree],[p_mem],ebx,MEM_RELEASE
	      @@:
	      @call   [CloseHandle],[h_file]
	      jmp     @done

	 .idm_options:
	      @call   [DialogBoxParam],[h_inst],ID_OPTIONS,[h_wnd],OptionsDlgProc,ebx
	      jmp     @done

	 .idm_about:
	      @call   [DialogBoxParam],[h_inst],ID_ABOUT,[h_wnd],AboutDlgProc,ebx
	      jmp     @done

   @wmsize:
	      @call   [SendMessage],[h_toolbar],TB_AUTOSIZE,ebx,ebx

	      ;   
	      ; ------------------------
	      mov     ecx,[lparam]
	      and     ecx,0FFFFh
	      mov     eax,[lparam]
	      shr     eax,16
	      sub     eax,24
	      @call   [MoveWindow],[h_iwnd],ebx,eax,ecx,24,TRUE

	      ;   
	      ; -------------------------
	      mov     ecx,[lparam]
	      and     ecx,0FFFFh
	      mov     eax,[lparam]
	      shr     eax,16
	      sub     eax,53
	      @call   [MoveWindow],[h_ownd],ebx,28,ecx,eax,TRUE
	      jmp     @done

   @wminitmenu:
	      jmp     @done

   @wmactivate:
	      @call   [SetFocus],[h_iwnd]
	      jmp     @done

   @wmclose:
	      @call   set_ini_color,ini_path,sec_Colors,key_Text,[chatlist_colors]
	      @call   set_ini_color,ini_path,sec_Colors,key_Background,[chatlist_colors+4]
	      @call   set_ini_color,ini_path,sec_Colors,key_SelText,[chatlist_colors+8]
	      @call   set_ini_color,ini_path,sec_Colors,key_SelBackground,[chatlist_colors+12]


	      @call   [GetWindowPlacement],dword [hwnd],wp
	      @call   set_ini_int,ini_path,sec_Window,key_Top,[wp.rcNormalPosition.top]
	      @call   set_ini_int,ini_path,sec_Window,key_Left,[wp.rcNormalPosition.left]
	      @call   set_ini_int,ini_path,sec_Window,key_Right,[wp.rcNormalPosition.right]
	      @call   set_ini_int,ini_path,sec_Window,key_Bottom,[wp.rcNormalPosition.bottom]

	      @call   [WritePrivateProfileString],sec_Options,key_Nickname,nick_name,ini_path
	      @call   [WritePrivateProfileString],sec_Options,key_Download,down_path,ini_path

	      @call   [DestroyWindow],dword [hwnd]
	      jmp     @finish

   @wmdestroy:
	      @call   [PostQuitMessage],ebx

   @done:     xor     eax,eax
   @finish:   @pop    ebx,esi,edi
	      @leave
	      ret

;
; #########################################################################
;

 set_ini_int:	        ; ini,sec,key,val

	 ini equ ebp+08h
	 sec equ ebp+0Ch
	 key equ ebp+10h
	 val equ ebp+14h

	      @enter
	      @call   [wsprintf],str_buffer,format_int,dword [val]
	      add     esp,3*4
	      @call   [WritePrivateProfileString],dword [sec],dword [key],str_buffer,dword [ini]
	      @leave
	      ret


 set_ini_color:         ; ini,sec,key,color

	 ini   equ ebp+08h
	 sec   equ ebp+0Ch
	 key   equ ebp+10h
	 color equ ebp+14h

	      @enter
	      @push   ebx,esi,edi
	      movzx   eax,byte [color]
	      movzx   ebx,byte [color+1]
	      movzx   ecx,byte [color+2]
	      @call   [wsprintf],str_buffer,format_color,eax,ebx,ecx
	      add     esp,5*4
	      @call   [WritePrivateProfileString],dword [sec],dword [key],str_buffer,dword [ini]
	      @pop    ebx,esi,edi
	      @leave
	      ret

 get_ini_int:	        ; ini,sec,key,val

	 ini equ ebp+08h
	 sec equ ebp+0Ch
	 key equ ebp+10h
	 val equ ebp+14h

	      @enter
	      @push   ebx,esi,edi
	      mov     [str_buffer],0
	      @call   [GetPrivateProfileString],dword [sec],dword [key],str_buffer,str_buffer,MAX_PATH,dword [ini]
	      mov     esi,str_buffer
	      cmp     byte [esi],0
	      je      @F
	      call    atoi
	      jc      @F
	      mov     ebx,[val]
	      mov     [ebx],eax
	 @@:  @pop    ebx,esi,edi
	      @leave
	      ret

 get_ini_color:         ; ini,sec,key,lpcolor

	 ini	 equ ebp+08h
	 sec	 equ ebp+0Ch
	 key	 equ ebp+10h
	 lpcolor equ ebp+14h

	      @enter
	      @push   ebx,esi,edi
	      mov     [str_buffer],0
	      @call   [GetPrivateProfileString],dword [sec],dword [key],str_buffer,str_buffer,MAX_PATH,dword [ini]
	      mov     esi,str_buffer
	      cmp     byte [esi],0
	      je      .done
	      call    atoi
	      jc      .done
	      cmp     eax,0FFh
	      ja      .done
	      mov     edi,eax
	      call    .find
	      jne     .done
	      call    atoi
	      jc      .done
	      cmp     eax,0FFh
	      ja      .done
	      shl     eax,8
	      or      edi,eax
	      call    .find
	      jne     .done
	      call    atoi
	      jc      .done
	      cmp     eax,0FFh
	      ja      .done
	      shl     eax,16
	      or      edi,eax
	      mov     ebx,[lpcolor]
	      mov     [ebx],edi
	 .done:
	      @pop    ebx,esi,edi
	      @leave
	      ret
	 .find:
	      lodsb
	      cmp     al,20h
	      je      .find
	      cmp     al,9
	      je      .find
	      cmp     al,2Ch
	      retn

 atoi:
	      @enter
	      lodsb
	      cmp     al,20h
	      je      atoi
	      cmp     al,9
	      je      atoi
	      mov     bl,al
	      xor     eax,eax
	      xor     edx,edx
	      cmp     bl,'-'
	      je      atoi_digit
	      cmp     bl,'+'
	      je      atoi_digit
	      dec     esi
	 atoi_digit:
	      mov     dl,[esi]
	      sub     dl,30h
	      jc      atoi_done
	      cmp     dl,9
	      ja      atoi_done
	      mov     ecx,eax
	      shl     ecx,1
	      jc      atoi_overflow
	      shl     ecx,1
	      jc      atoi_overflow
	      add     eax,ecx
	      shl     eax,1
	      jc      atoi_overflow
	      js      atoi_overflow
	      add     eax,edx
	      jc      atoi_overflow
	      inc     esi
	      jmp     atoi_digit
	 atoi_overflow:
	      stc
	      @leave
	      ret
	 atoi_done:
	      cmp     bl,'-'
	      jne     atoi_sign_ok
	      neg     eax
	 atoi_sign_ok:
	      clc
	      @leave
	      ret

 SetBmpColor:	        ; hBitmap

	 virtual at ebp+0Ch
	      mDC	dd ?
	      hBrush	dd ?
	      hOldBmp	dd ?
	      hReturn	dd ?
	      hOldBrush dd ?
	 end virtual

	      @enter
	      ;     .
	      sub     esp,5*4
	      ;
	      @push   ebx,esi,edi
	      @call   [CreateCompatibleDC],ebx
	      mov     [mDC],eax
	      @call   [SelectObject],eax,dword [ebp+08h]
	      mov     [hOldBmp],eax
	      @call   [GetSysColor],COLOR_BTNFACE
	      @call   [CreateSolidBrush],eax
	      mov     [hBrush],eax
	      @call   [SelectObject],[mDC],eax
	      mov     [hOldBrush],eax
	      @call   [GetPixel],[mDC],1,1
	      @call   [ExtFloodFill],[mDC],1,1,eax,1
	      @call   [SelectObject],[mDC],[hOldBrush]
	      @call   [DeleteObject],[hBrush]
	      @call   [SelectObject],[mDC],dword [ebp+08h]
	      mov     [hReturn],eax
	      @call   [DeleteDC],[mDC]
	      mov     eax,[hReturn]
	      @pop    ebx,esi,edi
	      @leave
	      ret

 SendToDisplay:         ;hWnd,lpzMsg

	      @enter
	      @push   ebx,esi,edi
	      xor     ebx,ebx
	      @call   [SendMessage],dword [ebp+08h],WM_GETTEXTLENGTH,ebx,ebx
	      mov     esi,eax
	      mov     edi,[ebp+0Ch]
	      or      ecx,-1
	      xor     eax,eax
	      repnz   scas byte [edi]
	      xor     ecx,-1
	      add     ecx,esi
	      inc     esi
	      @call   [VirtualAlloc],ebx,ecx,MEM_COMMIT,PAGE_READWRITE
	      or      eax,eax
	      jz      .out_of_memory
	      mov     [p_mem],eax
	      @call   [SendMessage],dword [ebp+08h],WM_GETTEXT,esi,eax
	      add     eax,[p_mem]
	      @call   [lstrcpy],eax,dword [ebp+0Ch]
	      @call   [SendMessage],dword [ebp+08h],WM_SETTEXT,ebx,[p_mem]
	      @call   [VirtualFree],[p_mem],ebx,MEM_RELEASE
	      xor     eax,eax
	      inc     eax
	 .out_of_memory:
	      @pop    ebx,esi,edi
	      @leave
	      ret
;
; #########################################################################
;
  include 'dlgproc.inc'
;
; #########################################################################
;
 section '.idata' import data readable writeable

	library kernel32,'KERNEL32.DLL',\
		user32,'USER32.DLL',\
		gdi32,'GDI32.DLL',\
		comctl32,'COMCTL32.DLL',\
		comdlg32,'COMDLG32.DLL',\
		wsock32,'WSOCK32.DLL'

	include '%fasminc%/apia/kernel32.inc'
	include '%fasminc%/apia/user32.inc'
	include '%fasminc%/apia/gdi32.inc'
	include '%fasminc%/apia/comctl32.inc'
	include '%fasminc%/apia/comdlg32.inc'
	include '%fasminc%/apia/wsock32.inc'
;
; #########################################################################
;
 section '.rsrc' resource from 'gemoroy.res' data readable
;
; #########################################################################
;
 section '.data' data readable writeable
;
; #########################################################################
;
 include 'strings.inc'
;
 h_inst 	   dd ?
 h_wnd		   dd ?
 h_dll		   dd ?
 h_accel	   dd ?
 h_iwnd 	   dd ?
 h_ownd 	   dd ?
 h_toolbar	   dd ?

 h_file 	   dd ?
 p_mem		   dd ?
 tmp_var_buffer    dd ?

 msg		   MSG
 wc		   WNDCLASS
 s_tbbutton	   TBBUTTON
 s_tbaddbitmap	   TBADDBITMAP
 wp		   WINDOWPLACEMENT
 ofn		   OPENFILENAME
 cf		   CHOOSEFONT
 cc		   CHOOSECOLOR

 chatlist_colors   rd 4
 result_buffer	   rb MAX_PATH*2
 str_buffer	   rb MAX_PATH
 ini_path	   rb MAX_PATH
 log_path	   rb MAX_PATH
 down_path	   rb MAX_PATH
 nick_name	   rb 20