.equ	SEMOP,		     1
.equ 	SEMGET,		     2
.equ 	SEMCTL,		     3
.equ 	MSGSND,		    11
.equ 	MSGRCV,		    12
.equ 	MSGGET,		    13
.equ 	MSGCTL,		    14
.equ 	SHMAT,		    21
.equ 	SHMDT,		    22
.equ 	SHMGET,		    23
.equ 	SHMCTL,		    24
.equ	SEM_UNDO,  	0x1000		# undo the operation on exit
.equ	GETPID,    	    11		# get sempid
.equ	GETVAL,    	    12		# get semval
.equ 	GETALL,  	    13       	# get all semval's
.equ 	GETNCNT, 	    14       	# get semncnt
.equ 	GETZCNT, 	    15       	# get semzcnt
.equ 	SETVAL,  	    16       	# set semval
.equ 	SETALL,  	    17       	# set all semval's
.equ 	SEM_STAT, 	    18
.equ 	SEM_INFO,  	    19
.equ 	IPC_CREAT,        00001000	# create if key is nonexistent
.equ 	IPC_EXCL,         00002000	# fail if key exists
.equ 	IPC_NOWAIT,       00004000	# return error on wait
.equ 	IPC_DIPC,         00010000	# make it distributed
.equ 	IPC_OWN,      	  00020000	# this machine is the DIPC owner
.equ 	IPC_RMID,                0	# remove resource
.equ 	IPC_SET,                 1	# set ipc_perm options
.equ 	IPC_STAT,                2	# get ipc_perm options
.equ 	IPC_INFO,                3	# see ipcs
.equ 	SHM_R,		      0400
.equ 	SHM_W,		      0200
.equ	SHM_RDONLY,	    010000	# read-only access
.equ	SHM_RND,	    020000	# round attach address to SHMLBA boundary
.equ	SHM_REMAP,	    040000	# take-over region on attach
.equ 	SHM_LOCK, 	    	11
.equ 	SHM_UNLOCK, 	    	12
.equ	SEEK_SET,	     	 0
.equ	SEEK_CUR,            	 1
.equ	SEEK_END,            	 2
.equ 	CSIGNAL,	0x000000ff	# signal mask to be sent at exit
.equ 	CLONE_VM,	0x00000100	# set if VM shared between processes
.equ 	CLONE_FS,	0x00000200	# set if fs info shared between processes
.equ 	CLONE_FILES,	0x00000400	# set if open files shared between processes
.equ 	CLONE_SIGHAND,	0x00000800	# set if signal handlers and blocked signals shared
.equ 	CLONE_PID,	0x00001000	# set if pid shared
.equ 	CLONE_PTRACE,	0x00002000	# set if we want to let tracing continue on the child too
.equ 	CLONE_VFORK,	0x00004000	# set if the parent wants the child to wake it up on mm_release
.equ 	CLONE_PARENT,	0x00008000	# set if we want to have the same parent as the cloner
.equ 	CLONE_THREAD,	0x00010000	# Same thread group?
.equ 	CLONE_NEWNS,	0x00020000	# New namespace group?
.equ 	WNOHANG,	0x00000001
.equ 	WUNTRACED,	0x00000002

.equ 	__WNOTHREAD,	0x20000000	# Don't wait on children of other threads in this group
.equ 	__WALL,		0x40000000	# Wait on all children, regardless of type
.equ 	__WCLONE,	0x80000000	# Wait only on non-SIGCHLD children

# net.h ******************************************************************
.equ 	SYS_SOCKET,		 1
.equ 	SYS_BIND,		 2
.equ	SYS_CONNECT,		 3
.equ 	SYS_LISTEN,		 4
.equ 	SYS_ACCEPT,		 5
.equ 	SYS_GETSOCKNAME,	 6
.equ 	SYS_GETPEERNAME,	 7
.equ 	SYS_SOCKETPAIR,		 8
.equ 	SYS_SEND,		 9
.equ 	SYS_RECV,		10
.equ 	SYS_SENDTO,		11
.equ 	SYS_RECVFROM,		12
.equ 	SYS_SHUTDOWN,		13
.equ 	SYS_SETSOCKOPT,		14
.equ 	SYS_GETSOCKOPT,		15
.equ 	SYS_SENDMSG,		16
.equ 	SYS_RECVMSG,		17
# net.h ******************************************************************

# socket.h ***************************************************************
.equ 	AF_UNSPEC,		 0
.equ 	AF_UNIX,		 1	# Unix domain sockets
.equ 	AF_LOCAL,		 1	# POSIX name for AF_UNIX
.equ 	AF_INET,		 2	# Internet IP Protocol
.equ 	AF_AX25,		 3	# Amateur Radio AX.25
.equ 	AF_IPX,			 4	# Novell IPX
.equ 	AF_APPLETALK,		 5	# AppleTalk DDP
.equ 	AF_NETROM,		 6	# Amateur Radio NET/ROM
.equ 	AF_BRIDGE,		 7	# Multiprotocol bridge
.equ 	AF_ATMPVC,		 8	# ATM PVCs
.equ 	AF_X25,			 9	# Reserved for X.25 project
.equ 	AF_INET6,		10	# IP version 6
.equ 	AF_ROSE,		11	# Amateur Radio X.25 PLP
.equ 	AF_DECnet,		12	# Reserved for DECnet project
.equ 	AF_NETBEUI,		13	# Reserved for 802.2LLC project
.equ 	AF_SECURITY,		14	# Security callback pseudo AF
.equ 	AF_KEY,			15      # PF_KEY key management API
.equ 	AF_NETLINK,		16
.equ 	AF_ROUTE,		16 	# Alias to emulate 4.4BSD
.equ	AF_PACKET,		17	# Packet family
.equ 	AF_ASH,			18	# Ash
.equ 	AF_ECONET,		19	# Acorn Econet
.equ 	AF_ATMSVC,		20	# ATM SVCs
.equ 	AF_SNA,			22	# Linux SNA Project (nutters!)
.equ 	AF_IRDA,		23	# IRDA sockets
.equ 	AF_PPPOX,		24	# PPPoX sockets
.equ 	AF_WANPIPE,		25	# Wanpipe API Sockets
.equ 	AF_LLC,			26	# Linux LLC
.equ 	AF_BLUETOOTH,		31	# Bluetooth sockets
.equ 	AF_MAX,			32	# For now..

.equ 	SOL_SOCKET,		 1
.equ 	SO_DEBUG,		 1
.equ 	SO_REUSEADDR,		 2
.equ 	SO_TYPE,		 3
.equ 	SO_ERROR,		 4
.equ 	SO_DONTROUTE,		 5
.equ 	SO_BROADCAST,		 6
.equ 	SO_SNDBUF,		 7
.equ 	SO_RCVBUF,		 8
.equ 	SO_KEEPALIVE,		 9
.equ 	SO_OOBINLINE,		10
.equ 	SO_NO_CHECK,		11
.equ 	SO_PRIORITY,		12
.equ 	SO_LINGER,		13
.equ 	SO_BSDCOMPAT,		14
.equ 	SO_REUSEPORT,		15
.equ 	SO_PASSCRED,		16
.equ 	SO_PEERCRED,		17
.equ 	SO_RCVLOWAT,		18
.equ 	SO_SNDLOWAT,		19
.equ 	SO_RCVTIMEO,		20
.equ 	SO_SNDTIMEO,		21
.equ 	SO_SECURITY_AUTHENTICATION,		22
.equ 	SO_SECURITY_ENCRYPTION_TRANSPORT,	23
.equ 	SO_SECURITY_ENCRYPTION_NETWORK,		24
.equ 	SO_BINDTODEVICE,	25
.equ 	SO_ATTACH_FILTER,       26
.equ 	SO_DETACH_FILTER,       27
.equ 	SO_PEERNAME,		28
.equ 	SO_TIMESTAMP,		29
.equ 	SCM_TIMESTAMP,		29
.equ 	SO_ACCEPTCONN,		30

.equ 	SOCK_STREAM,		 1	# stream (connection) socket
.equ 	SOCK_DGRAM,		 2	# datagram (conn.less) socket
.equ 	SOCK_RAW,		 3	# raw socket
.equ 	SOCK_RDM,		 4	# reliably-delivered message
.equ 	SOCK_SEQPACKET,		 5	# sequential packet socket
.equ 	SOCK_PACKET,		10	# linux specific
# socket.h ***************************************************************

# in.h *******************************************************************
.equ	IPPROTO_IP, 		 0	# Dummy protocol for TCP
.equ  	IPPROTO_ICMP, 		 1	# Internet Control Message Protocol
.equ	IPPROTO_IGMP, 		 2	# Internet Group Management Protocol
.equ	IPPROTO_IPIP, 		 4	# IPIP tunnels (older KA9Q tunnels use 94)
.equ	IPPROTO_TCP, 		 6	# Transmission Control Protocol
.equ	IPPROTO_EGP, 		 8	# Exterior Gateway Protocol
.equ	IPPROTO_PUP, 		12	# PUP protocol
.equ	IPPROTO_UDP, 		17	# User Datagram Protocol
.equ	IPPROTO_IDP, 		22	# XNS IDP protocol
.equ	IPPROTO_RSVP, 		46	# RSVP protocol
.equ	IPPROTO_GRE, 		47	# Cisco GRE tunnels (rfc 1701,1702)
.equ  	IPPROTO_IPV6,	 	41	# IPv6-in-IPv4 tunnelling
.equ	IPPROTO_PIM,   	       103	# Protocol Independent Multicast
.equ  	IPPROTO_ESP, 		50      # Encapsulation Security Payload protocol
.equ	IPPROTO_AH, 		51      # Authentication Header protocol
.equ	IPPROTO_COMP,          108      # Compression Header protocol
.equ  	IPPROTO_RAW,	       255	# Raw IP packets
# in.h *******************************************************************
